from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


absolute_import = _Mock()

compilers = _Mock()

division = _Mock()

dummy_fortran_file = _Mock()

intel_version_match = _Mock()

print_function = _Mock()

simple_version_match = _Mock()

sys = _Mock()



class BaseIntelFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  exe_extension = ''
  library_switch = '-o '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class FCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  exe_extension = ''
  library_switch = '-o '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelEM64TFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'intelem'
  description = 'Intel Fortran Compiler for 64-bit apps'
  exe_extension = ''
  library_switch = '-o '
  module_dir_switch = '-module '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelEM64VisualFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  ar_exe = 'lib.exe'
  compile_switch = '/c '
  compiler_type = 'intelvem'
  description = 'Intel Visual Fortran Compiler for 64-bit apps'
  exe_extension = ''
  library_switch = '/OUT:'
  module_dir_switch = '/module:'
  module_include_switch = '/I'
  obj_extension = '.o'
  object_switch = '/Fo'
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'intel'
  description = 'Intel Fortran Compiler for 32-bit apps'
  exe_extension = ''
  library_switch = '-o '
  module_dir_switch = '-module '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelItaniumFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'intele'
  description = 'Intel Fortran Compiler for Itanium apps'
  exe_extension = ''
  library_switch = '-o '
  module_dir_switch = '-module '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelItaniumVisualFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  ar_exe = 'lib.exe'
  compile_switch = '/c '
  compiler_type = 'intelev'
  description = 'Intel Visual Fortran Compiler for Itanium apps'
  exe_extension = ''
  library_switch = '/OUT:'
  module_dir_switch = '/module:'
  module_include_switch = '/I'
  obj_extension = '.o'
  object_switch = '/Fo'
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class IntelVisualFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  ar_exe = 'lib.exe'
  compile_switch = '/c '
  compiler_type = 'intelv'
  description = 'Intel Visual Fortran Compiler for 32-bit apps'
  exe_extension = ''
  library_switch = '/OUT:'
  module_dir_switch = '/module:'
  module_include_switch = '/I'
  obj_extension = '.o'
  object_switch = '/Fo'
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

