[comment {-*- practcl -*-}]
[vset VERSION 0.11]
[manpage_begin practcl n [vset VERSION]]
[keywords practcl]
[copyright {2016-2018 Sean Woods <yoda@etoyoc.com>}]
[moddesc {The The Proper Rational API for C to Tool Command Language Module}]
[titledesc {The Practcl Module}]
[category {TclOO}]
[require TclOO 1.0]
[require practcl [vset VERSION]]
[description]
The Practcl module is a tool for integrating large modules for C API
Tcl code that requires custom Tcl types and TclOO objects.

[section COMMANDS]
[list_begin definitions]

[call [cmd CPUTS] [arg varname] [arg body] [opt [arg body]...]]
Appends blocks of text to a buffer. This command tries to reduce the number
of line breaks between bodies.

[call [cmd practcl::_isdirectory] [arg path]]
Returns true if [arg path] is a directory, using the test 

[list_end]

[list_begin definitions]
[call [cmd practcl::object] [arg "parent"] [opt [arg "keyvaluelist"]]]

A generic Practcl object

[call [cmd practcl::library] [opt [arg "keyvaluelist"]]]

A Practcl object representing a library container

[call [cmd practcl::exe] [opt [arg "keyvaluelist"]]]

A Practcl object representing a wrapped executable

[call [cmd practcl::product] [arg "parent"] [opt [arg "keyvaluelist"]]]

A Practcl object representing a compiled product

[call [cmd practcl::cheader] [arg "parent"] [opt [arg "keyvaluelist"]]]

A Practcl object representing an externally generated c header

[call [cmd practcl::csource] [arg "parent"] [opt [arg "keyvaluelist"]]]

A Practcl object representing an externally generated c source file

[call [cmd practcl::module] [arg "parent"] [opt [arg "keyvaluelist"]]]

A Practcl object representing a dynamically generated C/H/Tcl suite

[call [cmd practcl::submodule] [arg "parent"] [opt [arg "keyvaluelist"]]]

A Practcl object representing a dynamically generated C/H/Tcl suite, subordinate to a module
[list_end]

[vset CATEGORY practcl]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
