/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.event;

import org.piccolo2d.PNode;
import org.piccolo2d.event.PDragSequenceEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventFilter;
import org.piccolo2d.util.PDimension;

public class PDragEventHandler
extends PDragSequenceEventHandler {
    private PNode draggedNode = null;
    private boolean raiseToTopOnPress = false;

    public PDragEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    protected PNode getDraggedNode() {
        return this.draggedNode;
    }

    protected void setDraggedNode(PNode draggedNode) {
        this.draggedNode = draggedNode;
    }

    protected boolean shouldStartDragInteraction(PInputEvent event) {
        return super.shouldStartDragInteraction(event) && event.getPickedNode() != event.getTopCamera();
    }

    protected void startDrag(PInputEvent event) {
        super.startDrag(event);
        this.draggedNode = event.getPickedNode();
        if (this.raiseToTopOnPress) {
            this.draggedNode.raiseToTop();
        }
    }

    protected void drag(PInputEvent event) {
        super.drag(event);
        PDimension d = event.getDeltaRelativeTo(this.draggedNode);
        this.draggedNode.localToParent(d);
        this.draggedNode.offset(d.getWidth(), d.getHeight());
    }

    protected void endDrag(PInputEvent event) {
        super.endDrag(event);
        this.draggedNode = null;
    }

    public boolean getRaiseToTopOnPress() {
        return this.raiseToTopOnPress;
    }

    public void setRaiseToTopOnPress(boolean raiseToTopOnPress) {
        this.raiseToTopOnPress = raiseToTopOnPress;
    }
}

