/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "PreviewPane.hpp"

#include "Help.hpp"

#include "wx/wx.h"
#include "wx/sizer.h"

using namespace indii;

PreviewPane::PreviewPane(wxWindow* parent, ImageResource* res, 
    Model* model, Controller* control) : wxPanel(parent, wxID_ANY,
    wxDefaultPosition, wxDefaultSize,
    wxTAB_TRAVERSAL|wxNO_FULL_REPAINT_ON_RESIZE|wxCLIP_CHILDREN|wxBORDER_NONE) {
  preview = new PreviewImage(this, res, model, control);

  wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
  sizer->Add(preview, 1, wxALIGN_CENTER|wxEXPAND);
  SetSizer(sizer);
}

void PreviewPane::OnHelp(wxHelpEvent& evt) {
  Help::show(510);
}

void PreviewPane::OnSetFocus(wxFocusEvent& evt) {
  #ifdef __WXMSW__
  getPreviewImage()->clear(true);
  Refresh();
  #endif
}

BEGIN_EVENT_TABLE(PreviewPane, wxPanel)
EVT_HELP(wxID_ANY, PreviewPane::OnHelp)
EVT_SET_FOCUS(PreviewPane::OnSetFocus)
END_EVENT_TABLE()
