/**
	@license GNU GPLv2
	PROJECT "trovacap"
	Copyright  2006 Danilo Cicerone

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation,
	Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
*/

/**
	@file trovacap.h
	@author Danilo Cicerone info@digitazero.org
	@date 2006-12-05
	@version 0.2.2
*/

#ifndef TROVACAP_H
#define TROVACAP_H

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/fl_ask.H>

#include "icons.h"
#include "dlg_help.h"
#include "dlg_info.h"
#include "db_table.h"

#if defined(WIN32)
   // Nothing to do here (Dev-C++ solve this problem)
#elif defined(__APPLE__)
   // Nothing to do here
#else
	#include <FL/x.H>
	#include <X11/xpm.h>
	#include "trovacap.xpm"
#endif

#include <string>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

using namespace std;

class TCWin {
	public:
		TCWin();
		~TCWin();
		void show();
		void hide();
		int visible();
		Fl_Window *win_main;
		Fl_Input *txt_loca;
		Fl_Input *txt_topo;
		Fl_Input *txt_fcap;
		Fl_Choice *cbo_prov;
		Fl_Output *lbl_data;
		Fl_Return_Button *btn_find;
		Fl_Button *btn_topo;
		Fl_Button *btn_loca;
		Fl_Button *btn_help;
		Fl_Button *btn_info;
		Fl_Button *btn_esci;
		DB_Table *tb_loca;

	private:
		static Fl_Menu_Item mnu_prov[];
		
		string sigp;

		const static int winW = 800;

		const static int winH = 435;

		const static int cLoc = 7;

		sqlite3 *db;

		inline void
		cb_win_main_i();

		static void
		cb_win_main(Fl_Window*, void*);

		inline void
		load_prov();

		inline void
		build_query();

		inline void
		cb_txt_loca_i();

		static void
		cb_txt_loca(Fl_Input*, void*);

		inline void
		cb_txt_fcap_i();

		static void
		cb_txt_fcap(Fl_Input*, void*);

		inline void
		cb_cbo_prov_i();

		static void
		cb_cbo_prov(Fl_Choice*, void*);

		inline void
		cb_txt_topo_i();

		static void
		cb_txt_topo(Fl_Input*, void*);

		inline void
		cb_btn_find_i();

		static void
		cb_btn_find(Fl_Button*, void*);

		static void
		cb_tb_loca(Fl_Widget*, void*);

		inline void
		cb_tb_loca_i();

		inline void
		cb_btn_help_i();

		static void
		cb_btn_help(Fl_Button*, void*);

		inline void
		cb_btn_info_i();

		static void
		cb_btn_info(Fl_Button*, void*);

		inline void
		cb_btn_esci_i();

		static void
		cb_btn_esci(Fl_Button*, void*);
};

#endif
