#ifndef INCLUDED_GETOPT_H
#define INCLUDED_GETOPT_H
/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

/**
 * A portable getopt implementation, selecting the native version if
 * available.
 */

#if defined(USE_MY_GETOPT)
    /* We'll use mine */
#elif defined(_WIN32)
#   define USE_MY_GETOPT
#elif defined(__FreeBSD__) || defined (__OpenBSD__) || defined(__NetBSD__)
#   define USE_BSD_GETOPT
#elif _POSIX_C_SOURCE < 200112
#   define USE_MY_GETOPT
#elif defined(POSIXLY_CORRECT)
#   define USE_BSD_GETOPT
#endif


#ifdef USE_MY_GETOPT

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * A simplified getopt, works just like POSIX getopt, and implements
 * the GNU double-colon for optional arguments.
 */
int getopt(int argc, char* const argv[], const char* optstring);

/**
 * Option argument for argument-having options. Do not try to modify
 * this string as it should be (const char*) but isn't because we try
 * to be compatible with POSIX getopt.
 */
extern char *optarg;

/**
 * External getopt globals: non-option index, enable/disable errors
 * on stderr, invalid option character.
 */
extern int optind, opterr, optopt;

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#else /* !USE_MY_GETOPT */

#include <unistd.h>

#endif /* !USE_MY_GETOPT */

#endif /* INCLUDED_GETOPT_H */
