/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef __CIM_ENABLEDLOGICALELEMENT_H
#define __CIM_ENABLEDLOGICALELEMENT_H
#include "CIM_LogicalElement.h"
namespace CimClassNamespace
{

	// Class CIM_EnabledLogicalElement:
	// This class extends LogicalElement to abstract the concept of an element that is enabled and disabled, such as a LogicalDevice or a ServiceAccessPoint.
	class CIM_EnabledLogicalElement  : public CIM_LogicalElement
	{
	public:
		// type definitions
		typedef CimClassContainer<CIM_EnabledLogicalElement> CIM_EnabledLogicalElementContainer;

		// static const declarations
		static const string CLASS_NAME;
		static const string CLASS_URI;
		static const string CLASS_NS;
		static const string CLASS_NS_PREFIX;

		// class fields
		// EnabledState is an integer enumeration that indicates the enabled/disabled states of an element. It can also indicate the transitions between these requested states. For example, shutting down (value = 4) and starting (value=10) are transient states between enabled and disabled. The following text briefly summarizes the various enabled/disabled states:
		// Enabled (2) indicates that the element is/could be executing commands, will process any queued commands, and queues new requests.
		// Disabled (3) indicates that the element will not execute commands and will drop any new requests.
		// Shutting Down (4) indicates that the element is in the process of going to a Disabled state.
		// Not Applicable (5) indicates the element doesn't support being enabled/disabled.
		// Enabled but Offline (6) indicates that the element may be completing commands, and will drop any new requests.
		// Test (7) indicates that the element is in a test state.
		// Deferred (8) indicates that the element may be completing commands, but will queue any new requests.
		// Quiesce (9) indicates that the element is enabled but in a restricted mode. The element's behavior is similar to the Enabled state, but it only processes a restricted set of commands. All other requests are queued.
		// Starting (10) indicates that the element is in the process of going to an Enabled state. New requests are queued.
		// Legal values:
		// Unknown: 0
		// Other: 1
		// Enabled: 2
		// Disabled: 3
		// Shutting Down: 4
		// Not Applicable: 5
		// Enabled but Offline: 6
		// In Test: 7
		// Deferred: 8
		// Quiesce: 9
		// Starting: 10
		// DMTF Reserved: 11..32767
		// Vendor Reserved: 32768..65535
		unsigned short EnabledState;

		// This field determines whether the EnabledState field is valid.
		bool EnabledStateSpecified;

		// A string describing the element's enabled/disabled state when the EnabledState property is set to 1 ("Other"). This property MUST be set to NULL when EnabledState is any value other than 1.
		string OtherEnabledState;

		// This field determines whether the OtherEnabledState field is valid.
		bool OtherEnabledStateSpecified;

		// RequestedState is an integer enumeration indicating the last requested or desired state for the element. The actual state of the element is represented by EnabledState. This property is provided to compare the last requested and current enabled/disabled states. Note that when EnabledState is set to 5 ("Not Applicable"), then this property has no meaning. By default, the element's RequestedState is 5 ("No Change"). Refer to the EnabledState's property Description for explanations of the values in the RequestedState enumeration.
		//
		// It should be noted that there are two new values in RequestedState that build on the statuses of EnabledState. These are "Reboot" (10) and "Reset" (11). The former, Reboot, refers to doing a "Shut Down" and then moving to an "Enabled" state. The latter, Reset, indicates that the element is first "Disabled" and then "Enabled". The distinction between requesting "Shut Down" and "Disabled" should also be noted. The former, Shut Down, requests an orderly transition to the Disabled state, and MAY involve removing power, to completely erase any existing state. The latter, the Disabled state, requests an immediate disabling of the element, such that it will not execute or accept any commands or processing requests.
		//
		// This property is set as the result of a method invocation (such as Start or StopService on CIM_Service), or may be overridden and defined as WRITEable in a subclass. The method approach is considered superior to a WRITEable property, since it allows an explicit invocation of the operation and the return of a result code.
		//
		// It is possible that a particular instance of EnabledLogicalElement may not support RequestedStateChange. If this occurs, the value 12 ("Not Applicable") is used.
		// Legal values:
		// Enabled: 2
		// Disabled: 3
		// Shut Down: 4
		// No Change: 5
		// Offline: 6
		// Test: 7
		// Deferred: 8
		// Quiesce: 9
		// Reboot: 10
		// Reset: 11
		// Not Applicable: 12
		// DMTF Reserved: ..
		// Vendor Reserved: 32768..65535
		unsigned short RequestedState;

		// This field determines whether the RequestedState field is valid.
		bool RequestedStateSpecified;

		// An enumerated value indicating an administrator's default/startup configuration for an element's Enabled State. By default, the element is "Enabled" (value=2).
		// Legal values:
		// Enabled: 2
		// Disabled: 3
		// Not Applicable: 5
		// Enabled but Offline: 6
		// No Default: 7
		// DMTF Reserved: 8..32767
		// Vendor Reserved: 32768..65535
		unsigned short EnabledDefault;

		// This field determines whether the EnabledDefault field is valid.
		bool EnabledDefaultSpecified;

		// The date/time when the element's EnabledState last changed. If the state of the element has not changed and this property is populated, then it MUST be set to a 0 interval value. If a state change was requested, but rejected or not yet processed, the property MUST NOT be updated.
		DateTime TimeOfLastStateChange;

		// This field determines whether the TimeOfLastStateChange field is valid.
		bool TimeOfLastStateChangeSpecified;

		// Invoke RequestStateChange Classes:
		// Requests that the element's state be changed to the value specified in the RequestedState parameter. When the requested state change takes place, the element's EnabledState and RequestedState will be the same. Invoking the RequestStateChange method multiple times could result in earlier requests being overwritten/lost.
		// If 0 is returned, then the task completed successfully and the use of ConcreteJob was not required. If 4096 (0x1000) is returned, then the task will take some time to complete, ConcreteJob will be created, and its reference returned in the output parameter Job. Any other return code indicates an error condition.
		class RequestStateChange_INPUT : public Serializable
		{
		public:
			// class fields
			// The state requested for the element. This information will be placed into the instance's RequestedState property if the RequestStateChange method's return code is 0, 3, or 4096 (0x1000) - 'Completed with No Error', 'Timeout', or 'Job Started' respectively. Refer to the description of the EnabledState and RequestedState properties for the detailed meanings of the RequestedState values.
			// Legal values:
			// Enabled: 2
			// Disabled: 3
			// Shut Down: 4
			// Offline: 6
			// Test: 7
			// Defer: 8
			// Quiesce: 9
			// Reboot: 10
			// Reset: 11
			// DMTF Reserved: ..
			// Vendor Reserved: 32768..65535
			unsigned short RequestedState;

			// This field determines whether the RequestedState field is valid.
			bool RequestedStateSpecified;

			// A timeout period that specifies the maximum amount of time that the client expects the transition to the new state to take. The interval format MUST be used to specify the TimeoutPeriod. A value of 0 or a null parameter indicates that the client has no time requirements for the transition.
			// If this property does not contain 0 or null and the implementation doesn't support this parameter. A return code of 'Use Of Timeout Parameter Not Supported' MUST be returned.
			DateTime TimeoutPeriod;

			// This field determines whether the TimeoutPeriod field is valid.
			bool TimeoutPeriodSpecified;

			// Class Constructor
			RequestStateChange_INPUT();

			// Class Destructor
			~RequestStateChange_INPUT(){}

			// This function appends a serialization of this instance to the given node.
			void SerializeMembers(XMLElement& node) const;
		};

		class RequestStateChange_OUTPUT : public DeSerializable
		{
		public:
			// class fields
			// Reference to the job (may be null if task completed).
			EndpointReference Job;

			// This field determines whether the Job field is valid.
			bool JobSpecified;

			// Function Return Value:
			// Legal values:
			// Completed with No Error: 0
			// Not Supported: 1
			// Unknown/Unspecified Error: 2
			// Can NOT complete within Timeout Period: 3
			// Failed: 4
			// Invalid Parameter: 5
			// In Use: 6
			// DMTF Reserved: ..
			// Method Parameters Checked - Job Started: 4096
			// Invalid State Transition: 4097
			// Use of Timeout Parameter Not Supported: 4098
			// Busy: 4099
			// Method Reserved: 4100..32767
			// Vendor Specific: 32768..65535
			unsigned int ReturnValue;

			// Class Constructor
			RequestStateChange_OUTPUT();

			// Class Destructor
			~RequestStateChange_OUTPUT(){}

			// This function sets a field value according to the given node.
			void SetValue(const XMLElement& elem);

		};

		// Class Constructor
		CIM_EnabledLogicalElement(
			const string& objName = CIM_EnabledLogicalElement::CLASS_NAME,
			const string& uri = CIM_EnabledLogicalElement::CLASS_URI,
			const string& ns = CIM_EnabledLogicalElement::CLASS_NS,
			const string& nsPrefix = CIM_EnabledLogicalElement::CLASS_NS_PREFIX);

		// Class Destructor
		virtual ~CIM_EnabledLogicalElement(){}

		// This function appends a serialization of this instance to the given node.
		virtual void SerializeMembers(XMLElement& node) const;

		// This function returns the selector set of this instance.
		virtual NameValuePairs GetSelectorsList() const;

		// This function sets a field value according to the given node.
		virtual void SetValue(const XMLElement& node);

		// This function performs the Invoke RequestStateChange operation using the given input.
		// The output of the function is returned in the given output class.
		virtual void InvokeRequestStateChange(RequestStateChange_INPUT &input, RequestStateChange_OUTPUT &output,  const WsmanClient *cl = defaultProvider) const;

	};
}
#endif
