// vimix logo by Bruno Herbelin
// Created using Shadertoy-SVG: https://zduny.github.io/shadertoy-svg/

const vec3 positions[214] = vec3[214](vec3(0.050455196326022314, 0.8180193309141153, 0), vec3(0.015563537267873013, 0.7824538773812868, 0), vec3(-0.035604827943633136, 0.7821750046490954, 0), vec3(-0.07087161107600083, 0.8173580842947106, 0), vec3(-0.07142174249706436, 0.8692327056556415, 0), vec3(-0.03690925847907487, 0.9051764317968927, 0), vec3(0.014253193222357524, 0.9060130328371345, 0), vec3(0.04989103430569599, 0.8712163931521701, 0), vec3(0.05558910233845, 0.8451711418761098, 0), vec3(0.05559959305997386, 0.844182770753946, 0), vec3(0.10884617136529436, 0.7781897173750434, 0), vec3(0.03848067242809852, 0.7161682218366572, 0), vec3(-0.05699069962247929, 0.7154882108482512, 0), vec3(-0.12777887246900674, 0.7757418118748873, 0), vec3(-0.21883263278017057, 0.8050596608358976, 0), vec3(-0.3589872095446394, 0.7528522531835282, 0), vec3(-0.485139042615795, 0.6778847404621138, 0), vec3(-0.5950643019547109, 0.5828871702490261, 0), vec3(-0.6865391575224604, 0.4705895901216368, 0), vec3(-0.7573397792801161, 0.3437220476573176, 0), vec3(-0.8052423371887515, 0.2050145904334395, 0), vec3(-0.8280230012094396, 0.05719726602737396, 0), vec3(-0.8178524920320099, -0.13422624468782018, 0), vec3(-0.7483990749582864, -0.3528455643270012, 0), vec3(-0.6833058177260405, -0.4469564144757494, 0), vec3(-0.6248633896236316, -0.40098237950086757, 0), vec3(-0.4632665552922723, -0.27386140327513986, 0), vec3(-0.1985153147319624, -0.06559348579856628, 0), vec3(-0.0369184804006029, 0.061527490427161435, 0), vec3(0.021523947701805716, 0.1075015254020435, 0), vec3(0.029621392559368513, 0.12154480379027788, 0), vec3(0.029621392559368513, 0.15530768448490617, 0), vec3(0.03341976939602668, 0.20067771249421285, 0), vec3(0.061553085147254855, 0.2675659579898365, 0), vec3(0.11206026379784026, 0.31809611708375785, 0), vec3(0.17893144150235318, 0.3462465606073514, 0), vec3(0.2608150437690417, 0.3447046106727093, 0), vec3(0.3363763499541234, 0.3059492161985473, 0), vec3(0.3714286426920152, 0.2751960139432904, 0), vec3(0.39771731316702735, 0.2751960139432904, 0), vec3(0.4910688881796172, 0.26343796547453346, 0), vec3(0.5898410393845999, 0.20922540867408423, 0), vec3(0.623622912518863, 0.15571609922539864, 0), vec3(0.5931074224132069, 0.11971726991654374, 0), vec3(0.43876893904132236, 0.09402997950304537, 0), vec3(0.4036920110022577, 0.05896281341325449, 0), vec3(0.4036920110022577, -0.06964542696832732, 0), vec3(0.39747251598158545, -0.17371537177298646, 0), vec3(0.35074595971613715, -0.31037629188801974, 0), vec3(0.2650346571517243, -0.42301243844308734, 0), vec3(0.14841701868815552, -0.5036271686250287, 0), vec3(0.0961162411212547, -0.5701862981995771, 0), vec3(0.16243926438061, -0.7495247828110745, 0), vec3(0.17882604431523907, -0.7935801420826378, 0), vec3(0.18195800953852334, -0.7993489972461727, 0), vec3(0.2544503589969094, -0.7836562853038422, 0), vec3(0.3860912210228357, -0.729474855269655, 0), vec3(0.5574237814792025, -0.610847621912981, 0), vec3(0.7277292539753816, -0.395319740112378, 0), vec3(0.8040513128536171, -0.2009645348056739, 0), vec3(0.8271087445045374, -0.06023685111430965, 0), vec3(0.8254912171340636, 0.08814501681200593, 0), vec3(0.7976130094866171, 0.2335357473390275, 0), vec3(0.7454440810434076, 0.36915216195706224, 0), vec3(0.6712241172508573, 0.4924140680072788, 0), vec3(0.577192803555388, 0.6007412728308448, 0), vec3(0.4655898254034213, 0.6915535837689293, 0), vec3(0.3386548682413789, 0.7622708081626993, 0), vec3(0.19862761751568253, 0.8103127533533239, 0), vec3(0.19576143580217475, 0.20591205151295744, 0), vec3(0.17219612824357047, 0.18235187735010538, 0), vec3(0.17219612824357047, 0.1478698778887212, 0), vec3(0.19576143580217475, 0.12427064293283552, 0), vec3(0.23023574266758778, 0.12427064293283552, 0), vec3(0.25383497262503524, 0.1478698778887212, 0), vec3(0.25383496812644085, 0.18235187735010538, 0), vec3(0.23023572917180515, 0.20591205151295744, 0), vec3(-0.035300233153536566, -0.5473289912822765, 0), vec3(-0.041901187276161836, -0.5477189294219287, 0), vec3(-0.05950307597472091, -0.5477967551004701, 0), vec3(-0.12230376800485303, -0.5477967551004701, 0), vec3(-0.12257712257826875, -0.5856853035744094, 0), vec3(-0.06097919067116466, -0.7523949168597424, 0), vec3(-0.04334762374740733, -0.7993790718474989, 0), vec3(-0.035160414348591, -0.8164369834454297, 0), vec3(-0.01697581025558524, -0.8247577671006878, 0), vec3(0.0016746032663843393, -0.8249148879985218, 0), vec3(0.029356370881823093, -0.8242544993778906, 0), vec3(0.056163120450902104, -0.8228173884922876, 0), vec3(0.05368223725667082, -0.7788671108814444, 0), vec3(-0.016120164655103252, -0.5900784941496364, 0), vec3(-0.49620450753694045, -0.5549722427744661, 0), vec3(-0.5593917947514385, -0.5865443885400485, 0), vec3(-0.4826135393775819, -0.6693661650910154, 0), vec3(-0.27398579305184173, -0.7777568921881086, 0), vec3(-0.17478739024310028, -0.7680521216953449, 0), vec3(-0.24119631865606403, -0.5885847859513729, 0), vec3(-0.29153214810533123, -0.5477967551004701, 0), vec3(-0.44660086926914283, -0.5477967551004701, 0), vec3(-0.10219913370682694, 0.9948341084968355, 0), vec3(-0.29726787241015734, 0.9550185462753163, 0), vec3(-0.47653821280254055, 0.8792503224419831, 0), vec3(-0.6359793023737565, 0.771560289806962, 0), vec3(-0.7715602886135848, 0.6359793011803796, 0), vec3(-0.8792503190118051, 0.4765382093723628, 0), vec3(-0.9550185410581968, 0.29726786719303777, 0), vec3(-0.99483410224254, 0.10219912745253157, 0), vec3(-0.99483410224254, -0.10219912745253157, 0), vec3(-0.9550185410581968, -0.29726786719303777, 0), vec3(-0.8792503190118051, -0.4765382093723627, 0), vec3(-0.7715602886135848, -0.6359793011803796, 0), vec3(-0.6359793023737565, -0.7715602898069618, 0), vec3(-0.47653821280254055, -0.8792503224419832, 0), vec3(-0.29726787241015734, -0.9550185462753165, 0), vec3(-0.10219913370682694, -0.9948341084968355, 0), vec3(0.10219912105453102, -0.9948341084968355, 0), vec3(0.2972678607950372, -0.9550185462753165, 0), vec3(0.4765382029743622, -0.8792503224419832, 0), vec3(0.6359792947823789, -0.7715602898069618, 0), vec3(0.7715602834089613, -0.6359793011803796, 0), vec3(0.8792503160439825, -0.4765382093723627, 0), vec3(0.955018539877316, -0.29726786719303777, 0), vec3(0.994834102098835, -0.10219912745253157, 0), vec3(0.994834102098835, 0.10219912745253157, 0), vec3(0.955018539877316, 0.29726786719303777, 0), vec3(0.8792503160439825, 0.4765382093723628, 0), vec3(0.7715602834089613, 0.6359793011803796, 0), vec3(0.6359792947823789, 0.771560289806962, 0), vec3(0.4765382029743622, 0.8792503224419831, 0), vec3(0.2972678607950372, 0.9550185462753163, 0), vec3(0.10219912105453102, 0.9948341084968355, 0), vec3(0.023938944722174605, 0.9472483185202716, 0), vec3(0.07931198883736429, 0.9037992522641484, 0), vec3(0.17494961377754925, 0.857377027202975, 0), vec3(0.3289235663821729, 0.8108964238242982, 0), vec3(0.46952006985018097, 0.7382733127929726, 0), vec3(0.5938604692957696, 0.64238212481491, 0), vec3(0.6990661098331341, 0.5260972905960214, 0), vec3(0.78225833657647, 0.39229324084221795, 0), vec3(0.8405584946399731, 0.24384440625941117, 0), vec3(0.8710879291378394, 0.08362521755351204, 0), vec3(0.8705184517626027, -0.08942467509093799, 0), vec3(0.8356766694876652, -0.2601129876949895, 0), vec3(0.769374020111227, -0.41697999062417, 0), vec3(0.6751384151186145, -0.5564977723931537, 0), vec3(0.5564977659951533, -0.675138421516615, 0), vec3(0.41697998422616966, -0.7693740265092275, 0), vec3(0.2601129812969889, -0.8356766758856655, 0), vec3(0.08942466869293733, -0.8705184581606034, 0), vec3(-0.08942468134523335, -0.8705184581606034, 0), vec3(-0.26011299291210893, -0.8356766758856655, 0), vec3(-0.416979994054348, -0.7693740265092275, 0), vec3(-0.556497773586531, -0.675138421516615, 0), vec3(-0.6751384203232381, -0.5564977723931537, 0), vec3(-0.7693740230790496, -0.41697999062417, 0), vec3(-0.8356766706685461, -0.2601129876949895, 0), vec3(-0.8705184519063078, -0.08942467509093799, 0), vec3(-0.8712140531085225, 0.08227998843031814, 0), vec3(-0.841642132710385, 0.24004977399471683, 0), vec3(-0.7851254488116785, 0.38648849446543, 0), vec3(-0.7044053825229095, 0.5188631778040156, 0), vec3(-0.6022233149545844, 0.6344408519720313, 0), vec3(-0.4813206272172096, 0.7304885449310341, 0), vec3(-0.34443870042129154, 0.8042732846425826, 0), vec3(-0.19431891567733636, 0.8530620990682337, 0), vec3(-0.10156561696105436, 0.9013192215874467, 0), vec3(-0.047687145897062244, 0.9461526498433365, 0), vec3(-0.9999999936019994, 0, 0), vec3(-0.8750390453978446, 0, 0), vec3(-0.8292976761246388, -0.019274456501050086, 0), vec3(-0.6914032625836032, -0.45332631088793196, 0), vec3(-0.5737525418456426, -0.5937198762140448, 0), vec3(-0.48184376044273636, -0.5477967551004701, 0), vec3(-0.25628925693173765, -0.5477967551004701, 0), vec3(-0.15969445196742665, -0.8088401525462476, 0), vec3(-0.14419926240010855, 0.8217751853932623, 0), vec3(-0.13657665255715587, -0.5477967551004701, 0), vec3(-0.11515150817187816, 0.8672289805368345, 0), vec3(-0.07629315587327146, 0.8432392936018777, 0), vec3(-0.04697966069227755, -0.7902834653336817, 0), vec3(-0.04523019142241808, -0.5477967551004701, 0), vec3(-0.03198434690777895, -0.547171990346953, 0), vec3(-0.03120203139076586, -0.8238059395582171, 0), vec3(-0.012058733900951078, 0.9530146834752378, 0), vec3(-0.011411032315468837, 0.9108120962901639, 0), vec3(-0.009992979473998456, 0.7770964760260839, 0), vec3(-0.00942889975567926, 0.7070610509368496, 0), vec3(-6.398000532847404e-9, -0.8750390517958451, 0), vec3(-6.398000532847404e-9, 1, 0), vec3(-6.398000532847404e-9, -1, 0), vec3(0.01593818072726488, -0.8246475965303133, 0), vec3(0.029621392559368513, 0.1629810664609581, 0), vec3(0.029621392559368513, 0.11387142181422594, 0), vec3(0.05558671808355841, 0.8453957716766015, 0), vec3(0.055601977314865665, 0.8439581409534542, 0), vec3(0.06954641950934652, -0.8217736146841281, 0), vec3(0.08104282674412862, -0.5294275516969642, 0), vec3(0.09384567370082035, 0.8699156289269728, 0), vec3(0.1244042837684711, 0.8250241860415717, 0), vec3(0.16871577989419406, 0.1651108328833938, 0), vec3(0.1775126787577361, -0.7902835293136874, 0), vec3(0.18407306055969846, -0.8023923211709265, 0), vec3(0.21299474218713, 0.20938982716633248, 0), vec3(0.21299474218713, 0.12078257399623515, 0), vec3(0.216625447548136, 0.35004762991507987, 0), vec3(0.2573230330642912, 0.1651108328833938, 0), vec3(0.36545394485678506, 0.2751960139432904, 0), vec3(0.4036920110022577, -0.09887457250959608, 0), vec3(0.4036920110022577, 0.08819195895452303, 0), vec3(0.4036920110022577, 0.2751960139432904, 0), vec3(0.6281843504522716, 0.12555529046506608, 0), vec3(0.829621398957369, 0.012590593288510088, 0), vec3(0.8750390453978447, 0, 0), vec3(0.9999999936019994, 0, 0));
const ivec3 triangles[204] = ivec3[204](ivec3(0, 1, 3), ivec3(0, 3, 178), ivec3(0, 9, 194), ivec3(0, 178, 9), ivec3(1, 2, 3), ivec3(1, 185, 2), ivec3(4, 5, 7), ivec3(4, 7, 8), ivec3(4, 8, 178), ivec3(5, 6, 7), ivec3(5, 184, 6), ivec3(7, 193, 8), ivec3(8, 9, 178), ivec3(10, 67, 11), ivec3(10, 68, 67), ivec3(10, 198, 68), ivec3(11, 34, 186), ivec3(11, 35, 34), ivec3(11, 67, 204), ivec3(11, 204, 35), ivec3(12, 15, 13), ivec3(12, 33, 15), ivec3(12, 34, 33), ivec3(12, 186, 34), ivec3(13, 14, 175), ivec3(13, 15, 14), ivec3(15, 33, 16), ivec3(16, 32, 17), ivec3(16, 33, 32), ivec3(17, 27, 18), ivec3(17, 28, 27), ivec3(17, 32, 28), ivec3(18, 27, 19), ivec3(19, 27, 20), ivec3(20, 27, 21), ivec3(21, 26, 169), ivec3(21, 27, 26), ivec3(22, 26, 23), ivec3(22, 169, 26), ivec3(23, 24, 170), ivec3(23, 25, 24), ivec3(23, 26, 25), ivec3(28, 31, 29), ivec3(28, 32, 191), ivec3(28, 191, 31), ivec3(29, 30, 192), ivec3(29, 31, 30), ivec3(36, 66, 37), ivec3(36, 67, 66), ivec3(36, 204, 67), ivec3(37, 38, 206), ivec3(37, 39, 38), ivec3(37, 65, 209), ivec3(37, 66, 65), ivec3(37, 209, 39), ivec3(40, 63, 41), ivec3(40, 64, 63), ivec3(40, 65, 64), ivec3(40, 209, 65), ivec3(41, 62, 42), ivec3(41, 63, 62), ivec3(42, 62, 210), ivec3(43, 46, 44), ivec3(43, 60, 207), ivec3(43, 207, 46), ivec3(43, 210, 60), ivec3(44, 45, 208), ivec3(44, 46, 45), ivec3(47, 58, 48), ivec3(47, 59, 58), ivec3(47, 207, 59), ivec3(48, 57, 49), ivec3(48, 58, 57), ivec3(49, 56, 50), ivec3(49, 57, 56), ivec3(50, 51, 196), ivec3(50, 52, 51), ivec3(50, 55, 52), ivec3(50, 56, 55), ivec3(52, 55, 200), ivec3(53, 55, 54), ivec3(53, 200, 55), ivec3(54, 55, 201), ivec3(59, 207, 60), ivec3(60, 210, 211), ivec3(61, 210, 62), ivec3(61, 211, 210), ivec3(69, 199, 70), ivec3(69, 202, 199), ivec3(71, 73, 203), ivec3(71, 199, 73), ivec3(71, 203, 72), ivec3(73, 199, 202), ivec3(73, 202, 74), ivec3(74, 202, 205), ivec3(75, 205, 76), ivec3(76, 205, 202), ivec3(77, 90, 78), ivec3(77, 181, 90), ivec3(78, 90, 180), ivec3(79, 81, 80), ivec3(79, 90, 81), ivec3(79, 180, 90), ivec3(80, 81, 176), ivec3(81, 90, 82), ivec3(82, 89, 179), ivec3(82, 90, 89), ivec3(83, 85, 84), ivec3(83, 86, 85), ivec3(83, 179, 86), ivec3(84, 85, 182), ivec3(86, 89, 190), ivec3(86, 179, 89), ivec3(87, 89, 88), ivec3(87, 190, 89), ivec3(88, 89, 195), ivec3(91, 93, 92), ivec3(91, 98, 93), ivec3(91, 172, 98), ivec3(92, 93, 171), ivec3(93, 97, 94), ivec3(93, 98, 97), ivec3(94, 95, 174), ivec3(94, 96, 95), ivec3(94, 97, 96), ivec3(96, 97, 173), ivec3(99, 164, 100), ivec3(99, 165, 164), ivec3(99, 166, 165), ivec3(99, 188, 166), ivec3(100, 163, 101), ivec3(100, 164, 163), ivec3(101, 162, 102), ivec3(101, 163, 162), ivec3(102, 161, 103), ivec3(102, 162, 161), ivec3(103, 160, 104), ivec3(103, 161, 160), ivec3(104, 159, 105), ivec3(104, 160, 159), ivec3(105, 158, 106), ivec3(105, 159, 158), ivec3(106, 157, 167), ivec3(106, 158, 157), ivec3(107, 155, 108), ivec3(107, 156, 155), ivec3(107, 167, 156), ivec3(108, 155, 109), ivec3(109, 154, 110), ivec3(109, 155, 154), ivec3(110, 152, 111), ivec3(110, 153, 152), ivec3(110, 154, 153), ivec3(111, 151, 112), ivec3(111, 152, 151), ivec3(112, 150, 113), ivec3(112, 151, 150), ivec3(113, 150, 114), ivec3(114, 149, 189), ivec3(114, 150, 149), ivec3(115, 147, 116), ivec3(115, 148, 147), ivec3(115, 189, 148), ivec3(116, 147, 117), ivec3(117, 146, 118), ivec3(117, 147, 146), ivec3(118, 144, 119), ivec3(118, 145, 144), ivec3(118, 146, 145), ivec3(119, 143, 120), ivec3(119, 144, 143), ivec3(120, 142, 121), ivec3(120, 143, 142), ivec3(121, 142, 122), ivec3(122, 141, 213), ivec3(122, 142, 141), ivec3(123, 139, 124), ivec3(123, 140, 139), ivec3(123, 213, 140), ivec3(124, 138, 125), ivec3(124, 139, 138), ivec3(125, 137, 126), ivec3(125, 138, 137), ivec3(126, 136, 127), ivec3(126, 137, 136), ivec3(127, 135, 128), ivec3(127, 136, 135), ivec3(128, 134, 129), ivec3(128, 135, 134), ivec3(129, 133, 130), ivec3(129, 134, 133), ivec3(130, 131, 188), ivec3(130, 132, 131), ivec3(130, 133, 132), ivec3(131, 183, 188), ivec3(132, 133, 197), ivec3(140, 213, 212), ivec3(141, 212, 213), ivec3(148, 189, 187), ivec3(149, 187, 189), ivec3(156, 167, 168), ivec3(157, 168, 167), ivec3(164, 165, 177), ivec3(166, 188, 183));
const int len = 204;

bool sameSide( vec3 p1, vec3 p2, vec3 a, vec3 b ) {
    vec3 cp1 = cross(b-a, p1-a);
    vec3 cp2 = cross(b-a, p2-a);

    return dot(cp1, cp2) >= 0.0;
}

bool pointInTriangle( vec3 p, vec3 a, vec3 b, vec3 c ) {
    return sameSide(p, a, b, c) && sameSide(p, b, a, c) && sameSide(p, c, a, b);
}

float inPath( vec2 p ) {
    for (int i=0; i<len; i++) {
        ivec3 triangle = triangles[i];
        vec3 a = positions[triangle[0]];
        vec3 b = positions[triangle[1]];
        vec3 c = positions[triangle[2]];

        if (pointInTriangle(vec3(p, 0.0), a, b, c)) {
            return 1.0;
        }
    }

    return 0.0;
}

vec2 rotate( vec2 v, float a ) {
    float s = sin(a);
    float c = cos(a);
    mat2 m = mat2(c, -s, s, c);
    return m * v;
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    float step = 1.0 / iResolution.y;

    fragColor = vec4(vec3(0.0), 1.0);
    vec2 uv = fragCoord/iResolution.xy;
    uv *= 2.0;
    uv -= vec2(1.0);
    uv.x *= iResolution.x/iResolution.y;
    uv *= vec2(1.4, -1.4);
    uv = rotate(uv, iTime * 0.2);

    fragColor = vec4(inPath(uv));
}
