/*************************************************************************
*                                                                        *
*   1) This source code file, in unmodified form, and compiled classes   *
*      derived from it can be used and distributed without restriction,  *
*      including for commercial use.  (Attribution is not required       *
*      but is appreciated.)                                              *
*                                                                        *
*    2) Modified versions of this file can be made and distributed       *
*       provided:  the modified versions are put into a Java package     *
*       different from the original package, edu.hws;  modified          *
*       versions are distributed under the same terms as the original;   *
*       and the modifications are documented in comments.  (Modification *
*       here does not include simply making subclasses that belong to    *
*       a package other than edu.hws, which can be done without any      *
*       restriction.)                                                    *
*                                                                        *
*   David J. Eck                                                         *
*   Department of Mathematics and Computer Science                       *
*   Hobart and William Smith Colleges                                    *
*   Geneva, New York 14456,   USA                                        *
*   Email: eck@hws.edu          WWW: http://math.hws.edu/eck/            *
*                                                                        *
*************************************************************************/

package edu.hws.jcm.awt;

/**
 * JCMErrors can be generated by objects belonging to various classes
 * in edu.hws.jcm.awt and edu.hws.jcm.draw.  A JCMError can have an 
 * associated object, which is generally a ParseContext, InputObject,
 * or Computable.
 *
 * @author David Eck
 */
public class JCMError extends RuntimeException {
   /**
    * Object, possibly null, associated with this error.
    */
   public Object object;

   /**
    * Create a JCMError with the given error message and no associated object.
    *
    * @param message the error message associated with this JCMError.
    */
   public JCMError(String message) {
      this(message,null);
   }

   /**
    * Create a JCMError with the given error message and associated object.
    *
    * @param message the error message associated with this JCMError.
    * @param object the object associated with this JCMError.
    */
   public JCMError(String message, Object object) {
      super(message);
      this.object = object;
   }
}
