/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.DataTableInput;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;

public class DataPlot
extends Drawable
implements Computable {
    public static final int INTERCEPT = 0;
    public static final int SLOPE = 1;
    public static final int DATACT = 2;
    public static final int MISSINGCT = 3;
    public static final int STANDARDERROR = 4;
    public static final int CORRELATION = 5;
    private DataTableInput table;
    private long lastTableSN;
    private boolean autoChangeLimits = true;
    private int column1;
    private int column2;
    private Expression exp1;
    private Expression exp2;
    private boolean showRegressionLine = true;
    private boolean missingValueIsError = true;
    private double slope = Double.NaN;
    private double intercept = Double.NaN;
    private int dataCt;
    private int missingCt;
    private double correlation = Double.NaN;
    private double standardError = Double.NaN;
    private double[][] data;
    private Color lineColor = Color.black;
    private Color dataColor = Color.red;
    private static final int crossHalfSize = 2;

    public DataPlot() {
        this(null, 0, 1);
    }

    public DataPlot(DataTableInput dataTableInput) {
        this(dataTableInput, 0, 1);
    }

    public DataPlot(DataTableInput dataTableInput, int n, int n2) {
        this.table = dataTableInput;
        this.column1 = n;
        this.column2 = n2;
    }

    public DataPlot(DataTableInput dataTableInput, Expression expression, Expression expression2) {
        this.table = dataTableInput;
        this.exp1 = expression;
        this.exp2 = expression2;
        this.column1 = 0;
        this.column2 = 1;
    }

    public void setTable(DataTableInput dataTableInput) {
        if (dataTableInput == this.table) {
            return;
        }
        this.table = dataTableInput;
        this.lastTableSN = 0L;
        this.column1 = 0;
        this.column2 = 1;
        this.checkData();
    }

    public DataTableInput getTable() {
        return this.table;
    }

    public void setColumns(int n, int n2) {
        this.column1 = n;
        this.column2 = n2;
        this.exp2 = null;
        this.exp1 = null;
        this.lastTableSN = 0L;
        this.checkData();
    }

    public void setExpressions(Expression expression, Expression expression2) {
        this.exp1 = expression;
        this.exp2 = expression2;
        this.lastTableSN = 0L;
        this.checkData();
    }

    public void setShowRegressionLine(boolean bl) {
        if (bl != this.showRegressionLine) {
            this.showRegressionLine = bl;
            this.needsRedraw();
        }
    }

    public boolean getShowRegressionLine() {
        return this.showRegressionLine;
    }

    public void setMissingValueIsError(boolean bl) {
        this.missingValueIsError = bl;
    }

    public boolean getMissingValueIsError() {
        return this.missingValueIsError;
    }

    public void setAutoChangeLimits(boolean bl) {
        this.autoChangeLimits = bl;
    }

    public boolean getAutoChangeLimits() {
        return this.autoChangeLimits;
    }

    public Color getDataColor() {
        return this.dataColor;
    }

    public void setDataColor(Color color) {
        if (color != null) {
            this.dataColor = color;
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        if (color != null) {
            this.lineColor = color;
        }
    }

    public Value getValueObject(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Unknown code (" + n + ") for type of value object.");
        }
        return new SPV(n);
    }

    private void checkData() {
        if (this.table != null && this.lastTableSN == this.table.getSerialNumber()) {
            return;
        }
        try {
            this.compute();
        }
        catch (JCMError jCMError) {
            this.canvas.setErrorMessage(null, jCMError.getMessage());
        }
    }

    public void compute() {
        double[] dArray = this.getData();
        if (this.table != null) {
            this.lastTableSN = this.table.getSerialNumber();
        }
        if (dArray == null || !this.needsNewLimits(dArray, this.coords)) {
            this.needsRedraw();
        } else {
            this.coords.setLimits(dArray);
        }
    }

    public void draw(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        graphics.setColor(this.dataColor);
        if (this.table == null) {
            graphics.drawString("No table has been specified.", 20, 27);
            return;
        }
        if (this.column1 < 0 || this.column1 >= this.table.getColumnCount() || this.column2 < 0 || this.column2 >= this.table.getColumnCount()) {
            graphics.drawString("Illegal column numbers.", 20, 27);
            return;
        }
        if (this.data == null || this.data.length == 0) {
            graphics.drawString("Druk op de knop voor de datafile .", 20, 27);
            return;
        }
        this.checkData();
        for (n3 = 0; n3 < this.data.length; ++n3) {
            n2 = this.coords.xToPixel(this.data[n3][0]);
            n = this.coords.yToPixel(this.data[n3][1]);
            graphics.drawLine(n2 - 2, n, n2 + 2, n);
            graphics.drawLine(n2, n - 2, n2, n + 2);
        }
        n3 = 0;
        for (n2 = 0; n2 < this.data.length - 1; ++n2) {
            n = this.coords.xToPixel(this.data[n2][0]);
            int n4 = this.coords.yToPixel(this.data[n2][1]);
            int n5 = this.coords.xToPixel(this.data[n2 + 1][0]);
            int n6 = this.coords.yToPixel(this.data[n2 + 1][1]);
            if (n5 > n && n5 > n3) {
                n3 = n5;
            }
            graphics.drawLine(n, n4, n5, n6);
        }
        n3 = this.coords.xToPixel(n3);
        graphics.drawString("Xmax=" + n3, 20, 27);
        if (this.showRegressionLine && !Double.isNaN(this.slope)) {
            graphics.setColor(this.lineColor);
            if (Double.isInfinite(this.slope)) {
                n2 = this.coords.xToPixel(this.data[0][0]);
                graphics.drawLine(n2, this.coords.getTop(), n2, this.coords.getTop() + this.coords.getHeight());
            } else {
                double d = this.coords.pixelToX(this.coords.getLeft());
                double d2 = this.coords.pixelToX(this.coords.getLeft() + this.coords.getWidth());
                double d3 = this.slope * d + this.intercept;
                double d4 = this.slope * d2 + this.intercept;
                graphics.drawLine(this.coords.xToPixel(d), this.coords.yToPixel(d3) - 1, this.coords.xToPixel(d2), this.coords.yToPixel(d4) - 1);
            }
        }
    }

    private double[] getData() {
        double d;
        double d2;
        int n;
        int n2 = this.table == null ? 0 : this.table.getNonEmptyRowCount();
        double[] dArray = null;
        if (this.table == null || n2 == 0 || (this.exp1 == null || this.exp2 == null) && (this.column1 < 0 || this.column1 >= this.table.getColumnCount() || this.column2 < 0 || this.column2 >= this.table.getColumnCount())) {
            this.data = new double[0][2];
            this.dataCt = 0;
            this.missingCt = 0;
            this.slope = Double.NaN;
            this.intercept = Double.NaN;
            this.correlation = Double.NaN;
            this.standardError = Double.NaN;
            return null;
        }
        this.data = new double[n2][2];
        this.dataCt = 0;
        this.missingCt = 0;
        if (this.exp1 == null || this.exp2 == null) {
            for (n = 0; n < n2; ++n) {
                d2 = this.table.getCellContents(n + 1, this.column1);
                d = this.table.getCellContents(n + 1, this.column2);
                if (Double.isNaN(d2) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isInfinite(d)) {
                    if (this.missingValueIsError) {
                        throw new JCMError("Missing data in row " + this.table.getCurrentRowNumber() + " of table.", this);
                    }
                    ++this.missingCt;
                    continue;
                }
                this.data[this.dataCt][0] = d2;
                this.data[this.dataCt][1] = d;
                ++this.dataCt;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.table.setCurrentRowNumber(n + 1);
                d2 = this.exp1.getVal();
                d = this.exp2.getVal();
                if (Double.isNaN(d2) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isInfinite(d)) {
                    if (this.missingValueIsError) {
                        throw new JCMError("Missing data or undefined expression value for row " + this.table.getCurrentRowNumber() + " of table.", this);
                    }
                    ++this.missingCt;
                    continue;
                }
                this.data[this.dataCt][0] = d2;
                this.data[this.dataCt][1] = d;
                ++this.dataCt;
            }
        }
        if (this.dataCt < this.data.length) {
            double[][] dArray2 = new double[this.dataCt][2];
            for (int i = 0; i < this.dataCt; ++i) {
                dArray2[i] = this.data[i];
            }
            this.data = dArray2;
        }
        this.getRegressionStats();
        if (this.autoChangeLimits) {
            dArray = this.computeDesiredLimits();
        }
        return dArray;
    }

    private void getRegressionStats() {
        if (this.dataCt == 0) {
            this.standardError = Double.NaN;
            this.correlation = Double.NaN;
            this.intercept = Double.NaN;
            this.slope = Double.NaN;
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        double d = this.data[0][0];
        double d2 = this.data[0][1];
        double d3 = this.data[0][0] * this.data[0][1];
        double d4 = this.data[0][0] * this.data[0][0];
        double d5 = this.data[0][1] * this.data[0][1];
        for (int i = 1; i < this.dataCt; ++i) {
            if (this.data[0][0] != this.data[i][0]) {
                bl = false;
            }
            if (this.data[0][1] != this.data[i][1]) {
                bl2 = false;
            }
            d += this.data[i][0];
            d2 += this.data[i][1];
            d3 += this.data[i][0] * this.data[i][1];
            d4 += this.data[i][0] * this.data[i][0];
            d5 += this.data[i][1] * this.data[i][1];
        }
        double d6 = (double)this.dataCt * d4 - d * d;
        double d7 = (double)this.dataCt * d5 - d2 * d2;
        double d8 = (double)this.dataCt * d3 - d * d2;
        if (bl && bl2) {
            this.slope = 0.0;
            this.intercept = this.data[0][1];
            this.standardError = Double.NaN;
            this.correlation = Double.NaN;
        } else if (bl) {
            this.slope = Double.POSITIVE_INFINITY;
            this.standardError = Double.NaN;
            this.correlation = Double.NaN;
            this.intercept = Double.NaN;
        } else if (d6 == 0.0) {
            this.standardError = Double.NaN;
            this.correlation = Double.NaN;
            this.intercept = Double.NaN;
            this.slope = Double.NaN;
        } else {
            this.slope = d8 / d6;
            this.intercept = (d2 - this.slope * d) / (double)this.dataCt;
            this.correlation = d7 == 0.0 ? Double.NaN : d8 / Math.sqrt(d6 * d7);
            if (this.dataCt <= 2) {
                this.standardError = Double.NaN;
            } else {
                double d9 = 0.0;
                for (int i = 0; i < this.dataCt; ++i) {
                    double d10 = this.data[i][1] - (this.slope * this.data[i][0] + this.intercept);
                    d9 += d10 * d10;
                }
                this.standardError = Math.sqrt(d9 / (double)(this.dataCt - 2));
            }
        }
    }

    private double[] computeDesiredLimits() {
        if (this.data.length == 0) {
            return null;
        }
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        for (int i = 0; i < this.dataCt; ++i) {
            double d5 = this.data[i][0];
            double d6 = this.data[i][1];
            if (d5 > d2) {
                d2 = d5;
            }
            if (d5 < d) {
                d = d5;
            }
            if (d6 > d4) {
                d4 = d6;
            }
            if (!(d6 < d3)) continue;
            d3 = d6;
        }
        if (d > 0.0 && d2 - d > d2 / 2.0) {
            d = 0.0;
        }
        if (d3 > 0.0 && d4 - d3 > d4 / 2.0) {
            d3 = 0.0;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 == d) {
            d2 += 1.0;
            d -= 1.0;
        } else {
            double d7 = (d2 - d) / 15.0;
            d2 += d7;
            d -= d7;
        }
        if (d4 == d3) {
            d4 += 1.0;
            d3 -= 1.0;
        } else {
            double d8 = (d4 - d3) / 15.0;
            d4 += d8;
            d3 -= d8;
        }
        return new double[]{d, d2, d3, d4};
    }

    private boolean needsNewLimits(double[] dArray, CoordinateRect coordinateRect) {
        double[] dArray2 = new double[]{coordinateRect.getXmin(), coordinateRect.getXmax(), coordinateRect.getYmin(), coordinateRect.getYmax()};
        return dArray[0] < dArray2[0] || dArray[1] > dArray2[1] || dArray[2] < dArray2[2] || dArray[3] > dArray2[3] || dArray2[1] - dArray2[0] > 1.3 * (dArray[1] - dArray[0]) || dArray2[3] - dArray2[2] > 1.3 * (dArray[3] - dArray[2]) || dArray2[1] - dArray2[0] < (dArray[1] - dArray[0]) / 1.3 || dArray2[3] - dArray2[2] < (dArray[3] - dArray[2]) / 1.3;
    }

    private class SPV
    implements Value {
        private int code;

        SPV(int n) {
            this.code = n;
        }

        public double getVal() {
            DataPlot.this.checkData();
            switch (this.code) {
                case 0: {
                    return DataPlot.this.intercept;
                }
                case 1: {
                    return DataPlot.this.slope;
                }
                case 2: {
                    return DataPlot.this.dataCt;
                }
                case 3: {
                    return DataPlot.this.missingCt;
                }
                case 4: {
                    return DataPlot.this.standardError;
                }
            }
            return DataPlot.this.correlation;
        }
    }
}

