/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.ExpressionCommand;
import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.ParserContext;
import edu.hws.jcm.data.ParserExtension;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;

public abstract class FunctionParserExtension
implements Function,
ParserExtension,
ExpressionCommand {
    protected String name;
    private boolean parensCanBeOptional;

    public void setParensCanBeOptional(boolean bl) {
        this.parensCanBeOptional = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void doParse(Parser parser, ParserContext parserContext) {
        int n = parserContext.next();
        String string = parserContext.tokenString;
        if (n == 4 && (string.equals("(") || string.equals("[") && (parserContext.options & 8) != 0 || string.equals("{") && (parserContext.options & 0x10) != 0)) {
            String string2 = string.equals("(") ? ")" : (string.equals("[") ? "]" : "}");
            for (int i = 0; i < this.getArity(); ++i) {
                if (parser.parseExpression(parserContext)) {
                    throw new ParseError("An argument of a function cannot be a logical-valued expression.", parserContext);
                }
                n = parserContext.next();
                if (i == this.getArity() - 1) {
                    if (n == 4 && parserContext.tokenString.equals(",")) {
                        throw new ParseError("Too many parameters for function \"" + this.getName() + "\".", parserContext);
                    }
                    if (n == 4 && parserContext.tokenString.equals(string2)) continue;
                    throw new ParseError("Expected a \"" + string2 + "\" at the end of the paramter list for function \"" + this.getName() + "\".", parserContext);
                }
                if (n == 4 && parserContext.tokenString.equals(",")) continue;
                throw new ParseError("Exprected a comma followed by another argument for function \"" + this.getName() + "\".", parserContext);
            }
        } else if (this.getArity() == 1 && (parserContext.options & 0x200) != 0 && this.parensCanBeOptional) {
            if (parser.parseTerm(parserContext)) {
                throw new ParseError("The argument of a function must be a numerical expression.", parserContext);
            }
        } else {
            throw new ParseError("Parentheses required around parameter list of function \"" + this.getName() + "\".", parserContext);
        }
        parserContext.prog.addCommandObject(this);
    }

    public void apply(StackOfDouble stackOfDouble, Cases cases) {
        double[] dArray = new double[this.getArity()];
        for (int i = this.getArity() - 1; i >= 0; --i) {
            dArray[i] = stackOfDouble.pop();
        }
        stackOfDouble.push(this.getVal(dArray));
    }

    public void compileDerivative(ExpressionProgram expressionProgram, int n, ExpressionProgram expressionProgram2, Variable variable) {
        int n2;
        int n3;
        int[] nArray = new int[this.getArity()];
        int n4 = 1;
        for (n3 = 0; n3 < this.getArity(); ++n3) {
            nArray[this.getArity() - n3 - 1] = n - n4;
            if (n3 >= this.getArity() - 1) continue;
            n4 += expressionProgram.extent(n - n4);
        }
        n3 = 0;
        if (this.dependsOn(variable)) {
            n3 = 1;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                expressionProgram.copyExpression(nArray[n2], expressionProgram2);
            }
            expressionProgram2.addCommandObject((FunctionParserExtension)this.derivative(variable));
        }
        for (n2 = 0; n2 < this.getArity(); ++n2) {
            if (!expressionProgram.dependsOn(nArray[n2], variable)) continue;
            for (int i = 0; i < nArray.length; ++i) {
                expressionProgram.copyExpression(nArray[i], expressionProgram2);
            }
            expressionProgram2.addCommandObject((FunctionParserExtension)this.derivative(n2 + 1));
            expressionProgram.compileDerivative(nArray[n2], expressionProgram2, variable);
            expressionProgram2.addCommand(-3);
            if (n3 != 0) {
                expressionProgram2.addCommand(-1);
            }
            n3 = 1;
        }
        if (n3 == 0) {
            expressionProgram.addConstant(0.0);
        }
    }

    public int extent(ExpressionProgram expressionProgram, int n) {
        int n2 = 1;
        for (int i = 0; i < this.getArity(); ++i) {
            n2 += expressionProgram.extent(n - n2);
        }
        return n2;
    }

    public void appendOutputString(ExpressionProgram expressionProgram, int n, StringBuffer stringBuffer) {
        int[] nArray = new int[this.getArity()];
        int n2 = 1;
        for (int i = 0; i < this.getArity(); ++i) {
            nArray[this.getArity() - i - 1] = n - n2;
            if (i >= this.getArity() - 1) continue;
            n2 += expressionProgram.extent(n - n2);
        }
        String string = this.getName();
        stringBuffer.append(string == null ? "(unnamed function)" : string);
        stringBuffer.append('(');
        for (int i = 0; i < this.getArity(); ++i) {
            expressionProgram.appendOutputString(nArray[i], stringBuffer);
            if (i >= this.getArity() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
    }
}

