/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.ExpressionCommand;
import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.ParserContext;
import edu.hws.jcm.data.ParserExtension;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;

public class SummationParser
implements ParserExtension {
    private String name = "sum";

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void doParse(Parser parser, ParserContext parserContext) {
        ExpressionProgram expressionProgram;
        Variable variable;
        int n = parserContext.next();
        String string = parserContext.tokenString;
        if (n == 4 && (string.equals("(") || string.equals("[") && (parserContext.options & 8) != 0 || string.equals("{") && (parserContext.options & 0x10) != 0)) {
            String string2 = string.equals("(") ? ")" : (string.equals("[") ? "]" : "}");
            n = parserContext.next();
            if (n != 3) {
                throw new ParseError("Expected the summation variable as the first argument of " + this.name + ".", parserContext);
            }
            String string3 = parserContext.tokenString;
            n = parserContext.next();
            if (n != 4 || !parserContext.tokenString.equals(",")) {
                throw new ParseError("Exprected a comma after the index variable, " + string3 + ".", parserContext);
            }
            parser.parseExpression(parserContext);
            n = parserContext.next();
            if (n != 4 || !parserContext.tokenString.equals(",")) {
                throw new ParseError("Exprected a comma after the lower limit expression for " + this.name + ".", parserContext);
            }
            parser.parseExpression(parserContext);
            n = parserContext.next();
            if (n != 4 || !parserContext.tokenString.equals(",")) {
                throw new ParseError("Exprected a comma after the upper limit expression for " + this.name + ".", parserContext);
            }
            variable = new Variable(string3);
            parserContext.mark();
            parserContext.add(variable);
            expressionProgram = parserContext.prog;
            parserContext.prog = new ExpressionProgram();
            parser.parseExpression(parserContext);
            n = parserContext.next();
            if (n != 4 || !parserContext.tokenString.equals(string2)) {
                throw new ParseError("Expected a \"" + string2 + "\" at the end of the paramter list for " + this.name + ".", parserContext);
            }
        } else {
            throw new ParseError("Parentheses required around parameters of summation.", parserContext);
        }
        parserContext.revert();
        expressionProgram.addCommandObject(new Cmd(variable, parserContext.prog));
        parserContext.prog = expressionProgram;
    }

    private static class Cmd
    implements ExpressionCommand {
        private Variable sumVar;
        private ExpressionProgram sumExpr;

        Cmd(Variable variable, ExpressionProgram expressionProgram) {
            this.sumVar = variable;
            this.sumExpr = expressionProgram;
        }

        public void apply(StackOfDouble stackOfDouble, Cases cases) {
            double d = (double)Math.round(stackOfDouble.pop()) + 0.1;
            double d2 = Math.round(stackOfDouble.pop());
            if (Double.isNaN(d) && Double.isNaN(d2) || d - d2 > 1000000.0) {
                stackOfDouble.push(Double.NaN);
            }
            double d3 = 0.0;
            for (double d4 = d2; d4 <= d; d4 += 1.0) {
                this.sumVar.setVal(d4);
                d3 += this.sumExpr.getVal();
            }
            stackOfDouble.push(d3);
        }

        public void compileDerivative(ExpressionProgram expressionProgram, int n, ExpressionProgram expressionProgram2, Variable variable) {
            if (!this.sumExpr.dependsOn(variable)) {
                expressionProgram2.addConstant(0.0);
            } else {
                int n2 = expressionProgram.extent(n - 1);
                expressionProgram.copyExpression(n - 1 - n2, expressionProgram2);
                expressionProgram.copyExpression(n - 1, expressionProgram2);
                expressionProgram2.addCommandObject(new Cmd(this.sumVar, (ExpressionProgram)this.sumExpr.derivative(variable)));
            }
        }

        public int extent(ExpressionProgram expressionProgram, int n) {
            int n2 = expressionProgram.extent(n - 1);
            int n3 = expressionProgram.extent(n - 1 - n2);
            return n2 + n3 + 1;
        }

        public boolean dependsOn(Variable variable) {
            return this.sumExpr.dependsOn(variable);
        }

        public void appendOutputString(ExpressionProgram expressionProgram, int n, StringBuffer stringBuffer) {
            int n2 = expressionProgram.extent(n - 1);
            stringBuffer.append("sum(");
            stringBuffer.append(this.sumVar.getName());
            stringBuffer.append(", ");
            expressionProgram.appendOutputString(n - 1 - n2, stringBuffer);
            stringBuffer.append(", ");
            expressionProgram.appendOutputString(n - 1, stringBuffer);
            stringBuffer.append(", ");
            stringBuffer.append(this.sumExpr.toString());
            stringBuffer.append(")");
        }
    }
}

