/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.TrackPainter;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.structures.Coordinates;

public class Tracker
extends ObjectConstructor
implements TrackPainter {
    ConstructionObject PM;
    int PMax = 8;
    int PN;
    ConstructionObject P;
    ConstructionObject[] PO = new ConstructionObject[this.PMax];
    Vector V = new Vector();
    Vector[] VO = new Vector[this.PMax];
    double X;
    double Y;
    double DX;
    double DY;
    double[] XO = new double[this.PMax];
    double[] YO = new double[this.PMax];
    double[] DXO = new double[this.PMax];
    double[] DYO = new double[this.PMax];
    boolean Started;
    boolean[] StartedO = new boolean[this.PMax];
    boolean Other;

    public Tracker(ConstructionObject constructionObject, ConstructionObject[] constructionObjectArray) {
        this.P = constructionObject;
        this.PN = 0;
        for (int i = 0; i < constructionObjectArray.length && i < this.PMax && constructionObjectArray[i] != null; ++i) {
            this.PO[this.PN] = constructionObjectArray[i];
            this.VO[i] = new Vector();
            ++this.PN;
        }
    }

    public Tracker() {
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        if (this.P == null) {
            this.P = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (this.P == null) {
                this.P = zirkelCanvas.selectLine(mouseEvent.getX(), mouseEvent.getY());
            }
            if (this.P == null) {
                return;
            }
            this.P.setSelected(true);
            zirkelCanvas.repaint();
            this.Other = mouseEvent.isShiftDown();
            this.showStatus(zirkelCanvas);
        } else if (this.Other) {
            ConstructionObject constructionObject = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (constructionObject == null) {
                constructionObject = zirkelCanvas.selectLine(mouseEvent.getX(), mouseEvent.getY());
            }
            if (constructionObject != null) {
                constructionObject.setSelected(true);
                zirkelCanvas.repaint();
                this.PO[this.PN] = constructionObject;
                this.VO[this.PN] = new Vector();
                ++this.PN;
            }
            if (!mouseEvent.isShiftDown() || this.PN >= this.PMax) {
                this.Other = false;
            }
            this.showStatus(zirkelCanvas);
        } else {
            ConstructionObject constructionObject;
            this.PM = constructionObject = zirkelCanvas.selectMoveableObject(mouseEvent.getX(), mouseEvent.getY());
            if (this.PM != null) {
                zirkelCanvas.clearSelected();
                this.PM.setSelected(true);
                ((MoveableObject)((Object)this.PM)).startDrag(d2, d3);
                zirkelCanvas.repaint();
                this.showStatus(zirkelCanvas);
            }
            this.Started = false;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        if (this.P == null || this.Other) {
            zirkelCanvas.indicatePointsOrLines(mouseEvent.getX(), mouseEvent.getY());
        } else if (this.PM == null) {
            zirkelCanvas.indicateMoveableObjects(mouseEvent.getX(), mouseEvent.getY());
        } else {
            zirkelCanvas.clearIndicated();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (this.PM == null) {
            return;
        }
        ((MoveableObject)((Object)this.PM)).dragTo(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
        zirkelCanvas.validate();
        this.track(zirkelCanvas);
        zirkelCanvas.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (this.PM == null) {
            return;
        }
        this.PM.setSelected(false);
        this.PM = null;
        zirkelCanvas.repaint();
        this.showStatus(zirkelCanvas);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.clearSelected();
        this.PM = null;
        this.P = null;
        this.PN = 0;
        this.V = new Vector();
        this.showStatus(zirkelCanvas);
        zirkelCanvas.repaint();
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P == null || this.Other) {
            zirkelCanvas.showStatus(Zirkel.name("message.tracker.select"));
        } else if (this.PM == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.tracker.selectpoint"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.tracker.move"));
        }
    }

    public void track(ZirkelCanvas zirkelCanvas) {
        ConstructionObject constructionObject;
        if (this.P == null) {
            return;
        }
        if (this.P instanceof PointObject) {
            constructionObject = (PointObject)this.P;
            if (constructionObject.valid()) {
                this.V.addElement(new Coordinates(((PointObject)constructionObject).getX(), ((PointObject)constructionObject).getY()));
            }
        } else if (this.P instanceof PrimitiveLineObject && (constructionObject = (PrimitiveLineObject)this.P).valid()) {
            if (!this.Started) {
                this.X = ((PrimitiveLineObject)constructionObject).getX();
                this.Y = ((PrimitiveLineObject)constructionObject).getY();
                this.DX = ((PrimitiveLineObject)constructionObject).getDX();
                this.DY = ((PrimitiveLineObject)constructionObject).getDY();
                this.Started = true;
            } else {
                double d2;
                double d3 = ((PrimitiveLineObject)constructionObject).getX();
                double d4 = ((PrimitiveLineObject)constructionObject).getY();
                double d5 = ((PrimitiveLineObject)constructionObject).getDX();
                double d6 = d5 * this.DY - (d2 = ((PrimitiveLineObject)constructionObject).getDY()) * this.DX;
                if (Math.sqrt(Math.abs(d6)) > 1.0E-9) {
                    double d7 = (-(this.X - d3) * this.DY + this.DX * (this.Y - d4)) / -d6;
                    this.V.addElement(new Coordinates(d3 + d7 * d5, d4 + d7 * d2));
                }
                this.X = d3;
                this.Y = d4;
                this.DX = d5;
                this.DY = d2;
            }
        }
        for (int i = 0; i < this.PN; ++i) {
            double d8;
            if (this.PO[i] == null || !this.PO[i].valid()) continue;
            if (this.PO[i] instanceof PointObject) {
                PointObject pointObject = (PointObject)this.PO[i];
                this.VO[i].addElement(new Coordinates(pointObject.getX(), pointObject.getY()));
                continue;
            }
            if (!(this.PO[i] instanceof PrimitiveLineObject)) continue;
            PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.PO[i];
            if (!this.StartedO[i]) {
                this.XO[i] = primitiveLineObject.getX();
                this.YO[i] = primitiveLineObject.getY();
                this.DXO[i] = primitiveLineObject.getDX();
                this.DYO[i] = primitiveLineObject.getDY();
                this.StartedO[i] = true;
                continue;
            }
            double d9 = primitiveLineObject.getX();
            double d10 = primitiveLineObject.getY();
            double d11 = primitiveLineObject.getDX();
            double d12 = d11 * this.DYO[i] - (d8 = primitiveLineObject.getDY()) * this.DXO[i];
            if (Math.sqrt(Math.abs(d12)) > 1.0E-9) {
                double d13 = (-(this.XO[i] - d9) * this.DYO[i] + this.DXO[i] * (this.YO[i] - d10)) / -d12;
                this.VO[i].addElement(new Coordinates(d9 + d13 * d11, d10 + d13 * d8));
            }
            this.XO[i] = d9;
            this.YO[i] = d10;
            this.DXO[i] = d11;
            this.DYO[i] = d8;
        }
    }

    public Enumeration elements() {
        return this.V.elements();
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        double d2;
        double d3;
        double d4;
        double d5;
        Coordinates coordinates;
        if (this.P == null) {
            return;
        }
        Enumeration enumeration = this.V.elements();
        myGraphics.setColor(this.P);
        int n = zirkelCanvas.width() / 20;
        if (enumeration.hasMoreElements()) {
            coordinates = (Coordinates)enumeration.nextElement();
            d5 = zirkelCanvas.col(coordinates.X);
            d4 = zirkelCanvas.row(coordinates.Y);
            while (enumeration.hasMoreElements()) {
                coordinates = (Coordinates)enumeration.nextElement();
                d3 = zirkelCanvas.col(coordinates.X);
                d2 = zirkelCanvas.row(coordinates.Y);
                if (Math.abs(d5 - d3) < (double)n && Math.abs(d4 - d2) < (double)n) {
                    myGraphics.drawLine(d5, d4, d3, d2, this.P);
                } else {
                    myGraphics.drawLine(d5, d4, d5, d4, this.P);
                }
                d5 = d3;
                d4 = d2;
            }
        }
        for (int i = 0; i < this.PN; ++i) {
            if (this.PO[i] == null) continue;
            myGraphics.setColor(this.PO[i]);
            enumeration = this.VO[i].elements();
            if (!enumeration.hasMoreElements()) continue;
            coordinates = (Coordinates)enumeration.nextElement();
            d5 = zirkelCanvas.col(coordinates.X);
            d4 = zirkelCanvas.row(coordinates.Y);
            while (enumeration.hasMoreElements()) {
                coordinates = (Coordinates)enumeration.nextElement();
                d3 = zirkelCanvas.col(coordinates.X);
                d2 = zirkelCanvas.row(coordinates.Y);
                if (Math.abs(d5 - d3) < (double)n && Math.abs(d4 - d2) < (double)n) {
                    myGraphics.drawLine(d5, d4, d3, d2, this.PO[i]);
                } else {
                    myGraphics.drawLine(d5, d4, d5, d4, this.PO[i]);
                }
                d5 = d3;
                d4 = d2;
            }
        }
    }

    public void validate(ZirkelCanvas zirkelCanvas) {
    }

    public void save(XmlWriter xmlWriter) {
        if (this.P == null) {
            return;
        }
        xmlWriter.startTagStart("Track");
        xmlWriter.printArg("track", this.P.getName());
        for (int i = 0; i < this.PN; ++i) {
            xmlWriter.printArg("track" + i, this.PO[i].getName());
        }
        if (this.PM != null) {
            xmlWriter.printArg("move", this.PM.getName());
        }
        xmlWriter.finishTagNewLine();
    }

    public boolean useSmartBoard() {
        return false;
    }
}

