/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.EditorPane;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class FileMolPreview
extends EditorPane
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File file = null;

    public FileMolPreview(JFileChooser fc) {
        super(200, 200);
        fc.addPropertyChangeListener(this);
        this.setBackground(Color.WHITE);
        this.setBorder(true);
        this.setToolCursor();
        this.setEditable(false);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        boolean update = false;
        String prop = ev.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)ev.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            Molecule mol = null;
            if (this.file != null && this.file.isFile()) {
                try {
                    FileInputStream istr = new FileInputStream(this.file);
                    mol = MoleculeStream.readUnknown(istr);
                    istr.close();
                }
                catch (IOException e) {
                    mol = null;
                }
            }
            if (mol == null) {
                mol = new Molecule();
            }
            this.replace(mol);
            this.scaleToFit();
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    protected void paintComponent(Graphics g) {
        Dimension sz = this.getSize();
        int width = (int)sz.getWidth();
        int height = (int)sz.getHeight();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, width, height);
        super.paintComponent(g);
    }
}

