/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.ExpressionCommand;
import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.ParserContext;
import edu.hws.jcm.data.ParserExtension;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class DataTableInput
extends Panel
implements ParserExtension {
    private String objectName;
    private Vector rows;
    private Vector rowStrings;
    private String[] columnName;
    private int columnCount;
    private int currentRow = 1;
    private double emptyCellValue = Double.NaN;
    private boolean throwErrors = false;
    private boolean autoAddRows = true;
    private boolean showColumnTitles;
    private boolean showRowNumbers;
    private DisplayPanel canvas;
    private long serialNumber;
    private Color labelBackground = new Color(220, 220, 220);
    private Color cellBackground = new Color(255, 255, 220);
    private Color blankBackground = Color.gray;
    private Color gridColor = Color.blue;

    public DataTableInput() {
        this(null, 0);
    }

    public DataTableInput(String string, String[] stringArray) {
        this(string, stringArray == null ? 0 : stringArray.length);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setColumnName(i, stringArray[i]);
            }
        }
    }

    public DataTableInput(String string, int n) {
        if (n < 0) {
            n = 0;
        }
        this.setName(string);
        this.rowStrings = new Vector();
        this.rows = new Vector();
        this.rowStrings.addElement(null);
        this.rows.addElement(null);
        this.columnName = new String[n];
        for (int i = 0; i < n; ++i) {
            this.columnName[i] = "" + (char)(65 + i);
        }
        this.canvas = new DisplayPanel();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.add((Component)this.canvas, "Center");
        this.add((Component)this.canvas.vScroll, "East");
        this.columnCount = n;
    }

    @Override
    public void doParse(Parser parser, ParserContext parserContext) {
        ExpressionProgram expressionProgram;
        int n = parserContext.next();
        if (n != 4 || !parserContext.tokenString.equals(".")) {
            throw new ParseError("Expected a '.' after the name of a data table.", parserContext);
        }
        n = parserContext.next();
        if (n != 3) {
            throw new ParseError("Expected 'sum', 'count', or the name of a column after data table name.", parserContext);
        }
        String string = parserContext.tokenString;
        int n2 = -10;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!string.equalsIgnoreCase(this.getColumnName(i))) continue;
            n2 = i;
            break;
        }
        if (n2 == -10) {
            if (string.equalsIgnoreCase("sum")) {
                n2 = -1;
            } else if (string.equalsIgnoreCase("count")) {
                n2 = -2;
            }
        }
        if (n2 == -10) {
            throw new ParseError("Unrecognized table command \"" + string + "\".", parserContext);
        }
        if (n2 == -2) {
            if (parserContext.look() == 4 && parserContext.tokenString.equals("(")) {
                parserContext.next();
                if (parserContext.next() != 4 || !parserContext.tokenString.equals(")")) {
                    throw new ParseError("Missing right parenthesis; \"count\" does not take a parameter.", parserContext);
                }
            }
            parserContext.prog.addCommandObject(new DTEC(-2, null));
            return;
        }
        if (parserContext.next() != 4 || !parserContext.tokenString.equals("(")) {
            throw new ParseError("Expected a left parentheses after table command \"" + string + "\".", parserContext);
        }
        ExpressionProgram expressionProgram2 = parserContext.prog;
        parserContext.prog = expressionProgram = new ExpressionProgram();
        if (n2 == -1) {
            parserContext.mark();
            for (int i = 0; i < this.columnCount; ++i) {
                parserContext.add(this.getColumnVariable(i));
            }
            parserContext.add(this.getRowNumberVariable());
        }
        parser.parseExpression(parserContext);
        parserContext.prog = expressionProgram2;
        if (parserContext.next() != 4 || !parserContext.tokenString.equals(")")) {
            throw new ParseError("Missing right parenthesis.", parserContext);
        }
        parserContext.prog.addCommandObject(new DTEC(n2, expressionProgram));
        if (n2 == -1) {
            parserContext.revert();
        }
    }

    public int getNonEmptyRowCount() {
        int n;
        for (n = this.rows.size(); n > 0 && this.rows.elementAt(n - 1) == null; --n) {
        }
        return n;
    }

    public double getCellContents(int n, int n2) {
        if (n < 1 || n > this.rows.size() || n2 < 0 || n2 > this.columnCount) {
            return Double.NaN;
        }
        return this.canvas.getValue(n2, n);
    }

    public void setCellContents(int n, int n2, double d) {
        if (n < 1 || n > this.rows.size() || n2 < 0 || n2 > this.columnCount) {
            return;
        }
        this.canvas.setValue(n2, n, d);
    }

    public void setCurrentRowNumber(int n) {
        this.currentRow = n < 1 ? 1 : n;
    }

    public int getCurrentRowNumber() {
        return this.currentRow;
    }

    protected Variable getColumnVariable(final int n) {
        if (n < 0 || n >= this.columnCount) {
            throw new IllegalArgumentException("Column number out of range.");
        }
        return new Variable(this.getColumnName(n), 0.0){

            @Override
            public void setVal(double d) {
                if (DataTableInput.this.currentRow < DataTableInput.this.rows.size()) {
                    DataTableInput.this.canvas.setValue(n, DataTableInput.this.currentRow, d);
                }
                super.setVal(d);
            }

            @Override
            public double getVal() {
                if (DataTableInput.this.currentRow > DataTableInput.this.rows.size()) {
                    return Double.NaN;
                }
                return DataTableInput.this.canvas.getValue(n, DataTableInput.this.currentRow);
            }
        };
    }

    protected Variable getRowNumberVariable() {
        return new Variable("rowNumber", 0.0){

            @Override
            public void setVal(double d) {
                int n = (int)(d + 0.5);
                if (n < 1 || n > DataTableInput.this.getNonEmptyRowCount()) {
                    n = DataTableInput.this.getNonEmptyRowCount() + 1;
                }
                DataTableInput.this.currentRow = n;
                super.setVal(n);
            }

            @Override
            public double getVal() {
                return DataTableInput.this.currentRow;
            }
        };
    }

    public void addVariablesToParser(Parser parser) {
        parser.add(this.getRowNumberVariable());
        for (int i = 0; i < this.columnCount; ++i) {
            parser.add(this.getColumnVariable(i));
        }
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public void setThrowErrors(boolean bl) {
        this.throwErrors = bl;
    }

    public boolean getThrowErrors() {
        return this.throwErrors;
    }

    public void setEmptyCellValue(double d) {
        this.emptyCellValue = d;
    }

    public double getEmptyCellValue() {
        return this.emptyCellValue;
    }

    public void setAutoAddRows(boolean bl) {
        this.autoAddRows = bl;
        this.canvas.lastRowAutoAdded = false;
    }

    public boolean getAutoAddRows() {
        return this.autoAddRows;
    }

    @Override
    public void setName(String string) {
        this.objectName = string;
    }

    @Override
    public String getName() {
        return this.objectName;
    }

    public void setColumnName(int n, String string) {
        if (string != null) {
            this.columnName[n] = string;
        }
    }

    public String getColumnName(int n) {
        return this.columnName[n];
    }

    public void addRows(int n) {
        this.canvas.addRows(n, this.rows.size());
    }

    public void insertRow() {
        this.canvas.addRows(1, this.canvas.activeRow);
    }

    public void deleteCurrentRow() {
        String[] stringArray;
        if (this.canvas.activeRow == this.rows.size() - 1 && this.rows.size() > 1) {
            this.canvas.setActive(this.canvas.activeRow - 1, this.canvas.activeColumn);
            this.rows.removeElementAt(this.canvas.activeRow + 1);
            this.rowStrings.removeElementAt(this.canvas.activeRow + 1);
        } else {
            this.rows.removeElementAt(this.canvas.activeRow);
            this.rowStrings.removeElementAt(this.canvas.activeRow);
        }
        if (this.rows.size() == 0) {
            this.rows.addElement(null);
            this.rowStrings.addElement(null);
        }
        if ((stringArray = (String[])this.rowStrings.elementAt(this.canvas.activeRow)) == null || stringArray[this.canvas.activeColumn] == null) {
            this.canvas.input.setText("");
        } else {
            this.canvas.input.setText(stringArray[this.canvas.activeColumn]);
        }
        this.canvas.checkScroll();
        this.canvas.repaint();
        if (this.canvas.rowLabelCanvas != null) {
            this.canvas.rowLabelCanvas.repaint();
        }
        if (this.canvas.columnLabelCanvas != null) {
            this.canvas.columnLabelCanvas.repaint();
        }
        ++this.serialNumber;
    }

    public void clear() {
        this.rows = new Vector();
        this.rowStrings = new Vector();
        this.rows.addElement(null);
        this.rowStrings.addElement(null);
        this.canvas.setActive(0, 0);
        this.canvas.checkScroll();
        this.canvas.repaint();
        if (this.canvas.rowLabelCanvas != null) {
            this.canvas.rowLabelCanvas.repaint();
        }
        if (this.canvas.columnLabelCanvas != null) {
            this.canvas.columnLabelCanvas.repaint();
        }
        ++this.serialNumber;
    }

    public int getColumnCount() {
        return this.columnName.length;
    }

    public int addColumn() {
        return this.addColumn(null);
    }

    public int addColumn(String string) {
        int n;
        int n2 = this.columnName.length + 1;
        String[] stringArray = new String[n2];
        for (n = 0; n < this.columnName.length; ++n) {
            stringArray[n] = this.columnName[n];
        }
        stringArray[n2 - 1] = string == null ? "" + (char)(65 + n2 - 1) : string;
        this.columnName = stringArray;
        n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            int n3;
            Object[] objectArray;
            Object[] objectArray2;
            if (this.rows.elementAt(i) != null) {
                objectArray2 = (double[])this.rows.elementAt(i);
                objectArray = new double[n2];
                for (n3 = 0; n3 < objectArray2.length; ++n3) {
                    objectArray[n3] = objectArray2[n3];
                }
                objectArray[n2 - 1] = Double.NaN;
                this.rows.setElementAt(objectArray, i);
            }
            if (this.rowStrings.elementAt(i) == null) continue;
            objectArray2 = (String[])this.rows.elementAt(i);
            objectArray = new String[n2];
            for (n3 = 0; n3 < objectArray2.length; ++n3) {
                objectArray[n3] = objectArray2[n3];
            }
            this.rowStrings.setElementAt(objectArray, i);
        }
        if (this.canvas.hScroll != null) {
            this.canvas.checkScroll();
        }
        this.canvas.repaint();
        if (this.canvas.columnLabelCanvas != null) {
            this.canvas.columnLabelCanvas.repaint();
        }
        this.columnCount = this.columnName.length;
        ++this.serialNumber;
        return this.columnCount - 1;
    }

    public boolean getShowColumnTitles() {
        return this.showColumnTitles;
    }

    public void setShowColumnTitles(boolean bl) {
        if (bl == this.showColumnTitles) {
            return;
        }
        this.showColumnTitles = bl;
        if (this.showColumnTitles) {
            this.canvas.makeColumnLabelCanvas();
            this.add((Component)this.canvas.columnLabelCanvas, "North");
        } else {
            this.remove(this.canvas.columnLabelCanvas);
            this.canvas.columnLabelCanvas = null;
        }
    }

    public boolean getShowRowNumbers() {
        return this.showRowNumbers;
    }

    public void setShowRowNumbers(boolean bl) {
        if (bl == this.showRowNumbers) {
            return;
        }
        this.showRowNumbers = bl;
        if (this.showRowNumbers) {
            this.canvas.makeRowLabelCanvas();
            this.add((Component)this.canvas.rowLabelCanvas, "West");
        } else {
            this.remove(this.canvas.rowLabelCanvas);
            this.canvas.rowLabelCanvas = null;
        }
    }

    public Color getLabelBackground() {
        return this.labelBackground;
    }

    public void setLabelBackground(Color color) {
        if (color != null) {
            this.labelBackground = color;
        }
    }

    public Color getCellBackground() {
        return this.cellBackground;
    }

    public void setCellBackground(Color color) {
        if (color != null) {
            this.cellBackground = color;
        }
    }

    public Color getBlankBackground() {
        return this.blankBackground;
    }

    public void setBlankBackground(Color color) {
        if (color != null) {
            this.blankBackground = color;
        }
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        if (color != null) {
            this.gridColor = color;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean readFromStream(Reader var1_1) {
        var2_2 = new Vector<double[]>();
        var3_3 = this.columnCount;
        try {
            var4_4 = new StreamTokenizer(var1_1);
            var4_4.resetSyntax();
            var4_4.eolIsSignificant(true);
            var4_4.whitespaceChars(44, 44);
            var4_4.whitespaceChars(32, 32);
            var4_4.whitespaceChars(9, 9);
            var4_4.wordChars(97, 122);
            var4_4.wordChars(65, 90);
            var4_4.wordChars(48, 57);
            var4_4.wordChars(46, 46);
            var4_4.wordChars(43, 43);
            var4_4.wordChars(45, 45);
            var5_7 = var4_4.nextToken();
            block4: while (true) {
                if (var5_7 == 10) {
                    var5_7 = var4_4.nextToken();
                    continue;
                }
                if (var5_7 == -1) break;
                var6_9 = new double[var3_3];
                for (var7_10 = 0; var7_10 < var3_3; ++var7_10) {
                    if (var5_7 == 10 || var5_7 == -1) {
                        var6_9[var7_10] = NaN;
                        continue;
                    }
                    if (var5_7 == -3) {
                        if (var4_4.sval.equalsIgnoreCase("undefined")) {
                            var6_9[var7_10] = NaN;
                        } else {
                            try {
                                var8_11 = new Double(var4_4.sval);
                                var6_9[var7_10] = var8_11;
                            }
                            catch (NumberFormatException var8_12) {
                                throw new IOException("Illegal non-numeric data (" + var4_4.sval + ") encountered.");
                            }
                        }
                        var5_7 = var4_4.nextToken();
                        continue;
                    }
                    throw new IOException("Illegal non-numeric data encountered.");
                }
                var2_2.addElement(var6_9);
                while (true) {
                    if (var5_7 != 10 && var5_7 != -1) ** break;
                    continue block4;
                    var5_7 = var4_4.nextToken();
                }
                break;
            }
            if (this.rows.size() == 0) {
                throw new IOException("Empty data was found.");
            }
        }
        catch (Exception var4_5) {
            if (this.throwErrors) {
                throw new JCMError("Error while reading data:  " + var4_5, this);
            }
            return false;
        }
        this.canvas.setActive(0, 0);
        this.rows = var2_2;
        this.rowStrings = new Vector<E>();
        for (var4_6 = 0; var4_6 < this.rows.size(); ++var4_6) {
            var5_8 = new String[var3_3];
            var6_9 = (double[])this.rows.elementAt(var4_6);
            for (var7_10 = 0; var7_10 < var3_3; ++var7_10) {
                var5_8[var7_10] = Double.isNaN(var6_9[var7_10]) != false ? null : NumUtils.realToString(var6_9[var7_10]);
            }
            this.rowStrings.addElement(var5_8);
        }
        this.canvas.input.setText(((String[])this.rowStrings.elementAt(0))[0]);
        if (this.canvas.hScroll != null) {
            this.canvas.hScroll.setValue(0);
        }
        this.canvas.vScroll.setValue(0);
        this.canvas.checkScroll();
        this.canvas.repaint();
        if (this.canvas.rowLabelCanvas != null) {
            this.canvas.rowLabelCanvas.repaint();
        }
        if (this.canvas.columnLabelCanvas != null) {
            this.canvas.columnLabelCanvas.repaint();
        }
        ++this.serialNumber;
        return true;
    }

    private class DTEC
    implements ExpressionCommand {
        ExpressionProgram prog;
        int command;

        DTEC(int n, ExpressionProgram expressionProgram) {
            this.command = n;
            this.prog = expressionProgram;
        }

        @Override
        public void apply(StackOfDouble stackOfDouble, Cases cases) {
            if (this.command >= 0) {
                double d = this.prog.getVal();
                if (Double.isNaN(d) || d < 0.5 || d >= (double)DataTableInput.this.rows.size() + 0.5) {
                    stackOfDouble.push(Double.NaN);
                } else {
                    stackOfDouble.push(DataTableInput.this.canvas.getValue(this.command, (int)(d + 0.5)));
                }
            } else if (this.command == -1) {
                double d = 0.0;
                int n = DataTableInput.this.getNonEmptyRowCount();
                for (int i = 1; i <= n; ++i) {
                    DataTableInput.this.setCurrentRowNumber(i);
                    d += this.prog.getVal();
                }
                stackOfDouble.push(d);
            } else if (this.command == -2) {
                stackOfDouble.push(DataTableInput.this.getNonEmptyRowCount());
            }
        }

        @Override
        public void compileDerivative(ExpressionProgram expressionProgram, int n, ExpressionProgram expressionProgram2, Variable variable) {
            if (this.command != -1) {
                expressionProgram2.addConstant(0.0);
            } else {
                ExpressionProgram expressionProgram3 = (ExpressionProgram)this.prog.derivative(variable);
                expressionProgram2.addCommandObject(new DTEC(this.command, expressionProgram3));
            }
        }

        @Override
        public int extent(ExpressionProgram expressionProgram, int n) {
            return 1;
        }

        @Override
        public boolean dependsOn(Variable variable) {
            if (this.command == -2) {
                return false;
            }
            return this.prog.dependsOn(variable);
        }

        @Override
        public void appendOutputString(ExpressionProgram expressionProgram, int n, StringBuffer stringBuffer) {
            stringBuffer.append(DataTableInput.this.getName());
            stringBuffer.append('.');
            if (this.command == -2) {
                stringBuffer.append("count");
            } else if (this.command == -1) {
                stringBuffer.append("sum");
            } else {
                stringBuffer.append(DataTableInput.this.getColumnName(this.command));
            }
            stringBuffer.append("(");
            if (this.command != -2) {
                stringBuffer.append(this.prog.toString());
            }
            stringBuffer.append(")");
        }
    }

    private class DisplayPanel
    extends Panel
    implements TextListener,
    MouseListener,
    AdjustmentListener,
    ComponentListener {
        InputBox input;
        int activeRow = 0;
        int activeColumn = 0;
        int rowHeight = -1;
        int columnWidth;
        Scrollbar hScroll;
        Scrollbar vScroll;
        Canvas rowLabelCanvas;
        Canvas columnLabelCanvas;
        boolean lastRowAutoAdded;

        DisplayPanel() {
            this.setBackground(DataTableInput.this.cellBackground);
            this.input = new InputBox();
            this.vScroll = new Scrollbar(1);
            this.vScroll.setBackground(Color.lightGray);
            this.input.addTextListener(this);
            this.vScroll.addAdjustmentListener(this);
            this.addMouseListener(this);
            this.setLayout(null);
            this.add(this.input);
            this.addComponentListener(this);
        }

        void makeRowLabelCanvas() {
            this.rowLabelCanvas = new Canvas(){

                @Override
                public void paint(Graphics graphics) {
                    int n = DisplayPanel.this.vScroll.getValue() / DisplayPanel.this.rowHeight;
                    int n2 = this.getSize().height / DisplayPanel.this.rowHeight + 1;
                    int n3 = DataTableInput.this.rows.size();
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n4 = (DisplayPanel.this.rowHeight + fontMetrics.getAscent()) / 2;
                    int n5 = DisplayPanel.this.vScroll.getValue();
                    for (int i = n; i < n2 + n && i < n3; ++i) {
                        String string = "" + (i + 1);
                        int n6 = (this.getSize().width - fontMetrics.stringWidth(string)) / 2;
                        graphics.drawString(string, n6, n4 + DisplayPanel.this.rowHeight * i - n5);
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(35, 50);
                }
            };
            this.rowLabelCanvas.setBackground(DataTableInput.this.labelBackground);
        }

        void makeColumnLabelCanvas() {
            this.columnLabelCanvas = new Canvas(){

                @Override
                public void paint(Graphics graphics) {
                    int n = 0;
                    if (DisplayPanel.this.hScroll != null) {
                        n = DisplayPanel.this.hScroll.getValue() / DisplayPanel.this.columnWidth;
                    }
                    int n2 = DisplayPanel.this.rowLabelCanvas == null ? 0 : 35;
                    int n3 = (this.getSize().width - n2) / DisplayPanel.this.columnWidth + 1;
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n4 = (this.getSize().height + fontMetrics.getAscent()) / 2;
                    int n5 = DisplayPanel.this.hScroll == null ? 0 : DisplayPanel.this.hScroll.getValue();
                    for (int i = n; i < n + n3 && i < DataTableInput.this.columnCount; ++i) {
                        String string = DataTableInput.this.getColumnName(i);
                        int n6 = (DisplayPanel.this.columnWidth - fontMetrics.stringWidth(string)) / 2;
                        graphics.drawString(string, n2 + i * DisplayPanel.this.columnWidth + n6 - n5, n4);
                    }
                    graphics.setColor(Color.gray);
                    graphics.fillRect(0, 0, n2, this.getSize().height);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(50, 20);
                }
            };
            this.columnLabelCanvas.setBackground(DataTableInput.this.labelBackground);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.rowHeight != -1) {
                return;
            }
            Dimension dimension = this.input.getPreferredSize();
            this.rowHeight = dimension.height - 1;
            this.columnWidth = dimension.width - 1;
            this.input.setBounds(1, 1, this.columnWidth + 1, this.rowHeight + 1);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = this.hScroll == null ? 0 : this.hScroll.getValue();
            int n7 = this.vScroll.getValue();
            int n8 = this.getSize().width;
            int n9 = this.getSize().height;
            int n10 = DataTableInput.this.columnCount * this.columnWidth + 2;
            int n11 = DataTableInput.this.rows.size() * this.rowHeight + 2;
            int n12 = DataTableInput.this.rows.size();
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null) {
                n5 = (n7 + rectangle.y) / this.rowHeight;
                n4 = rectangle.height / this.rowHeight + 1;
                n3 = (n6 + rectangle.x) / this.columnWidth;
                n2 = rectangle.width / this.columnWidth + 1;
            } else {
                n5 = n7 / this.rowHeight;
                n4 = n9 / this.rowHeight + 1;
                n3 = n6 / this.columnWidth;
                n2 = n8 / this.columnWidth + 1;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n13 = (this.rowHeight + fontMetrics.getAscent()) / 2;
            for (n = n5; n < n5 + n4 && n < n12; ++n) {
                String[] stringArray = (String[])DataTableInput.this.rowStrings.elementAt(n);
                for (int i = 0; i < DataTableInput.this.columnCount; ++i) {
                    if (i == this.activeColumn && n == this.activeRow) continue;
                    graphics.setColor(DataTableInput.this.cellBackground);
                    graphics.fillRect(1 + i * this.columnWidth - n6, 1 + n * this.rowHeight - n7, this.columnWidth, this.rowHeight);
                    graphics.setColor(this.getForeground());
                    if (stringArray == null || stringArray[i] == null || stringArray[i].length() <= 0) continue;
                    String string = stringArray[i];
                    graphics.drawString(string, i * this.columnWidth + 5 - n6, n13 + n * this.rowHeight - n7);
                }
            }
            if (n8 > n10) {
                graphics.setColor(DataTableInput.this.blankBackground);
                graphics.fillRect(n10, 0, n8 - n10, n9);
            }
            if (n9 > n11) {
                graphics.setColor(DataTableInput.this.blankBackground);
                graphics.fillRect(0, n11, n8, n9 - n11);
            }
            graphics.setColor(DataTableInput.this.gridColor);
            graphics.drawRect(0, 0, n10, n11);
            graphics.drawRect(1, 1, n10 - 2, n11 - 2);
            for (n = -1; n < n5 + n4 && n < n12; ++n) {
                graphics.drawLine(0, 1 + (n + 1) * this.rowHeight - n7, n10 - 1, 1 + (n + 1) * this.rowHeight - n7);
            }
            for (n = 0; n <= DataTableInput.this.columnCount; ++n) {
                graphics.drawLine(1 + n * this.columnWidth - n6, 0, 1 + n * this.columnWidth - n6, n11 - 1);
            }
        }

        void setActive(int n, int n2) {
            if (n != this.activeRow || n2 != this.columnWidth) {
                int n3 = this.vScroll.getValue();
                int n4 = this.hScroll == null ? 0 : this.hScroll.getValue();
                int n5 = -n3 + n * this.rowHeight + 1;
                int n6 = -n4 + n2 * this.columnWidth + 1;
                this.input.setLocation(n6, n5);
                this.activeRow = n;
                this.activeColumn = n2;
                String[] stringArray = (String[])DataTableInput.this.rowStrings.elementAt(this.activeRow);
                if (stringArray == null || stringArray[this.activeColumn] == null) {
                    this.input.setText("");
                } else {
                    this.input.setText(stringArray[this.activeColumn]);
                }
            }
            this.ensureActiveVisible();
            this.input.selectAll();
            this.input.requestFocus();
        }

        void doRowDown() {
            int n = DataTableInput.this.rows.size();
            if (this.activeRow == n - 1 && DataTableInput.this.autoAddRows && DataTableInput.this.rows.elementAt(n - 1) != null) {
                this.addRows(1, n);
                this.lastRowAutoAdded = true;
            }
            if (this.activeRow < DataTableInput.this.rows.size() - 1) {
                this.setActive(this.activeRow + 1, this.activeColumn);
            } else {
                this.ensureActiveVisible();
                this.input.requestFocus();
            }
        }

        void doRowUp() {
            if (this.activeRow == 0) {
                return;
            }
            this.setActive(this.activeRow - 1, this.activeColumn);
            if (DataTableInput.this.autoAddRows && this.lastRowAutoAdded && this.activeRow == DataTableInput.this.rows.size() - 2 && DataTableInput.this.rows.elementAt(this.activeRow + 1) == null) {
                DataTableInput.this.rows.removeElementAt(DataTableInput.this.rows.size() - 1);
                DataTableInput.this.rowStrings.removeElementAt(DataTableInput.this.rowStrings.size() - 1);
                this.checkScroll();
                this.repaint();
                if (this.rowLabelCanvas != null) {
                    this.rowLabelCanvas.repaint();
                }
                this.input.requestFocus();
            }
            this.lastRowAutoAdded = false;
        }

        void doColumnRight() {
            int n = this.activeColumn + 1;
            if (n >= DataTableInput.this.columnCount) {
                n = 0;
            }
            this.setActive(this.activeRow, n);
        }

        void doColumnLeft() {
            int n = this.activeColumn - 1;
            if (n < 0) {
                n = DataTableInput.this.columnCount - 1;
            }
            this.setActive(this.activeRow, n);
        }

        void ensureActiveVisible() {
            int n = this.columnWidth * this.activeColumn + 1;
            int n2 = this.rowHeight * this.activeRow + 1;
            int n3 = this.hScroll == null ? 0 : this.hScroll.getValue();
            int n4 = this.vScroll.getValue();
            int n5 = n3 + this.getSize().width;
            int n6 = n4 + this.getSize().height;
            int n7 = 0;
            int n8 = 0;
            if (n + this.columnWidth > n5) {
                n7 = -(n + this.columnWidth - n5);
            }
            if (n < n3) {
                n7 = n3 - n;
            }
            if (n2 + this.rowHeight > n6) {
                n8 = -(n2 + this.rowHeight - n6);
            }
            if (n2 < n4) {
                n8 = n4 - n2;
            }
            if (n7 == 0 && n8 == 0) {
                return;
            }
            if (n7 != 0) {
                if (this.hScroll != null) {
                    this.hScroll.setValue(n3 - n7);
                }
                if (this.columnLabelCanvas != null) {
                    this.columnLabelCanvas.repaint();
                }
            }
            if (n8 != 0) {
                this.vScroll.setValue(n4 - n8);
                if (this.rowLabelCanvas != null) {
                    this.rowLabelCanvas.repaint();
                }
            }
            this.input.setLocation(n - (this.hScroll == null ? 0 : this.hScroll.getValue()), n2 - this.vScroll.getValue());
            this.repaint();
        }

        void addRows(int n, int n2) {
            DataTableInput.this.serialNumber++;
            if (n <= 0) {
                return;
            }
            if (n2 >= DataTableInput.this.rows.size()) {
                for (int i = 0; i < n; ++i) {
                    DataTableInput.this.rows.addElement(null);
                    DataTableInput.this.rowStrings.addElement(null);
                    this.lastRowAutoAdded = false;
                }
            } else {
                if (n2 < 0) {
                    n2 = 0;
                }
                for (int i = 0; i < n; ++i) {
                    DataTableInput.this.rows.insertElementAt(null, n2);
                    DataTableInput.this.rowStrings.insertElementAt(null, n2);
                }
                if (this.activeRow >= n2) {
                    String[] stringArray = (String[])DataTableInput.this.rowStrings.elementAt(this.activeRow);
                    if (stringArray == null || stringArray[this.activeColumn] == null) {
                        this.input.setText("");
                    } else {
                        this.input.setText(stringArray[this.activeColumn]);
                    }
                }
            }
            this.checkScroll();
            this.repaint();
            if (this.rowLabelCanvas != null) {
                this.rowLabelCanvas.repaint();
            }
        }

        void setValue(int n, int n2, double d) {
            String string = NumUtils.realToString(d);
            this.setRowData(n2 - 1, n, string, d);
            if (n == this.activeColumn && n2 - 1 == this.activeRow) {
                this.input.setText(string);
            } else {
                this.repaintItem(n2 - 1, n);
            }
        }

        double getValue(int n, int n2) {
            if (DataTableInput.this.rows.elementAt(n2 - 1) == null) {
                return DataTableInput.this.emptyCellValue;
            }
            double d = ((double[])DataTableInput.this.rows.elementAt(n2 - 1))[n];
            if (!Double.isNaN(d)) {
                return d;
            }
            String string = ((String[])DataTableInput.this.rowStrings.elementAt(n2 - 1))[n];
            if (string == null || string.length() == 0) {
                return DataTableInput.this.emptyCellValue;
            }
            if (DataTableInput.this.throwErrors) {
                throw new JCMError("Invalid numerical input in data table, column \"" + DataTableInput.this.getColumnName(n) + "\", row " + n2 + ".", this);
            }
            return Double.NaN;
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            String string = this.input.getText().trim();
            if (string.length() == 0) {
                this.setRowData(this.activeRow, this.activeColumn, string, Double.NaN);
            } else {
                double d;
                try {
                    Double d2 = new Double(string);
                    d = d2;
                }
                catch (NumberFormatException numberFormatException) {
                    d = Double.NaN;
                }
                if (Double.isNaN(d)) {
                    this.setRowData(this.activeRow, this.activeColumn, "bad input", d);
                } else {
                    this.setRowData(this.activeRow, this.activeColumn, string, d);
                }
            }
        }

        void setRowData(int n, int n2, String string, double d) {
            DataTableInput.this.serialNumber++;
            double[] dArray = (double[])DataTableInput.this.rows.elementAt(n);
            String[] stringArray = (String[])DataTableInput.this.rowStrings.elementAt(n);
            if (string.length() == 0) {
                if (stringArray == null || stringArray[n2] == null) {
                    return;
                }
                stringArray[n2] = null;
                dArray[n2] = Double.NaN;
                boolean bl = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    DataTableInput.this.rows.setElementAt(null, n);
                    DataTableInput.this.rowStrings.setElementAt(null, n);
                }
            } else {
                if (string.length() > 12) {
                    string = NumUtils.realToString(d, 12);
                }
                if (stringArray == null) {
                    int n3 = DataTableInput.this.columnCount;
                    dArray = new double[n3];
                    stringArray = new String[n3];
                    for (int i = 0; i < n3; ++i) {
                        dArray[i] = Double.NaN;
                    }
                    DataTableInput.this.rows.setElementAt(dArray, n);
                    DataTableInput.this.rowStrings.setElementAt(stringArray, n);
                }
                stringArray[n2] = string;
                dArray[n2] = d;
            }
        }

        protected void repaintItem(int n, int n2) {
            int n3 = n * this.rowHeight - this.vScroll.getValue();
            int n4 = n2 * this.columnWidth;
            if (this.hScroll != null) {
                n4 -= this.hScroll.getValue();
            }
            this.repaint(n4 + 1, n3 + 1, this.columnWidth - 1, this.rowHeight - 1);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            this.repaint();
            if (adjustmentEvent.getSource() == this.vScroll) {
                if (this.rowLabelCanvas != null) {
                    this.rowLabelCanvas.repaint();
                }
            } else if (this.columnLabelCanvas != null) {
                this.columnLabelCanvas.repaint();
            }
            int n = this.columnWidth * this.activeColumn + 1;
            if (this.hScroll != null) {
                n -= this.hScroll.getValue();
            }
            int n2 = this.rowHeight * this.activeRow + 1 - this.vScroll.getValue();
            this.input.setLocation(n, n2);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.hScroll == null ? 0 : this.hScroll.getValue();
            int n2 = this.vScroll.getValue();
            int n3 = (mouseEvent.getY() + n2 - 1) / this.rowHeight;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 >= DataTableInput.this.rows.size()) {
                n3 = DataTableInput.this.rows.size() - 1;
            }
            int n4 = (mouseEvent.getX() + n - 1) / this.columnWidth;
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 >= DataTableInput.this.columnCount) {
                n4 = DataTableInput.this.columnCount - 1;
            }
            if (n3 == this.activeRow && n4 == this.activeColumn) {
                this.ensureActiveVisible();
            } else {
                this.setActive(n3, n4);
            }
            int n5 = DataTableInput.this.rows.size() - 1;
            if (!this.lastRowAutoAdded || n5 == n3) {
                return;
            }
            this.lastRowAutoAdded = false;
            if (DataTableInput.this.rows.elementAt(n5) != null) {
                return;
            }
            DataTableInput.this.rows.removeElementAt(n5);
            DataTableInput.this.rowStrings.removeElementAt(n5);
            this.checkScroll();
            this.repaint();
            if (this.rowLabelCanvas != null) {
                this.rowLabelCanvas.repaint();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.checkScroll();
        }

        void checkScroll() {
            int n;
            int n2 = this.getSize().width;
            int n3 = this.getSize().height;
            if (this.rowHeight == -1 || n2 <= 1) {
                return;
            }
            int n4 = this.columnWidth * DataTableInput.this.columnCount + 2;
            int n5 = this.rowHeight * DataTableInput.this.rows.size() + 2;
            int n6 = this.vScroll.getValue();
            int n7 = this.hScroll == null ? 0 : this.hScroll.getValue();
            boolean bl = false;
            if (n2 >= n4 - 2) {
                if (this.hScroll != null) {
                    n = this.hScroll.getPreferredSize().height;
                    DataTableInput.this.remove(this.hScroll);
                    this.hScroll = null;
                    n3 += n;
                    bl = true;
                }
            } else {
                if (this.hScroll == null) {
                    this.hScroll = new Scrollbar(0);
                    this.hScroll.setBackground(Color.lightGray);
                    n = this.hScroll.getPreferredSize().height;
                    n3 -= n;
                    DataTableInput.this.add((Component)this.hScroll, "South");
                    this.hScroll.addAdjustmentListener(this);
                    bl = true;
                }
                if (n7 > n4 - n2) {
                    this.hScroll.setValues(n4 - n2, n2, 0, n4);
                } else {
                    this.hScroll.setValues(n7, n2, 0, n4);
                }
                this.hScroll.setUnitIncrement(this.columnWidth / 4);
                if (n2 > 1) {
                    this.hScroll.setBlockIncrement(3 * n2 / 4);
                }
            }
            if (n3 >= n5 - 2) {
                this.vScroll.setEnabled(false);
                this.vScroll.setValues(0, 1, 0, 1);
            } else {
                if (n6 > n5 - n3) {
                    this.vScroll.setValues(n5 - n3, n3, 0, n5);
                } else {
                    this.vScroll.setValues(n6, n3, 0, n5);
                }
                this.vScroll.setUnitIncrement(this.rowHeight);
                if (n3 > 1) {
                    this.vScroll.setBlockIncrement(3 * n3 / 4);
                }
                this.vScroll.setEnabled(true);
            }
            n = this.columnWidth * this.activeColumn + 1;
            if (this.hScroll != null) {
                n -= this.hScroll.getValue();
            }
            int n8 = this.rowHeight * this.activeRow + 1 - this.vScroll.getValue();
            this.input.setLocation(n, n8);
            if (bl) {
                DataTableInput.this.validate();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.rowHeight == -1) {
                return new Dimension(350, 200);
            }
            if (DataTableInput.this.columnCount >= 4) {
                return new Dimension(4 * this.columnWidth + 2, 6 * this.rowHeight + 2);
            }
            return new Dimension(DataTableInput.this.columnCount * this.columnWidth + 2, 6 * this.rowHeight + 2);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }
    }

    private class InputBox
    extends TextField {
        InputBox() {
            super(12);
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.enableEvents(24L);
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                boolean bl;
                int n = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                boolean bl2 = c != '\u0000' && Character.isDigit(c) || c == '.' || c == 'E' || c == '-' || c == '+' || c == 'e' || n == 127 || n == 8;
                boolean bl3 = bl = bl2 || c == '\u0000';
                if (!bl || n == 10 || n == 40 || n == 38 || n == 9) {
                    if (n == 10 || n == 40) {
                        DataTableInput.this.canvas.doRowDown();
                    } else if (n == 38) {
                        DataTableInput.this.canvas.doRowUp();
                    } else if (n == 9) {
                        DataTableInput.this.canvas.doColumnRight();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    keyEvent.consume();
                } else if (n == 37 && this.getCaretPosition() == 0) {
                    DataTableInput.this.canvas.doColumnLeft();
                    keyEvent.consume();
                } else if (n == 39 && this.getCaretPosition() == this.getText().length()) {
                    DataTableInput.this.canvas.doColumnRight();
                    keyEvent.consume();
                }
            }
            super.processKeyEvent(keyEvent);
        }

        @Override
        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                DataTableInput.this.canvas.ensureActiveVisible();
            }
            super.processMouseEvent(mouseEvent);
        }
    }
}

