/* wconfig_color.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2006-2008,2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef WCONFIG_COLOR_HH
#define WCONFIG_COLOR_HH

#include "wdefines.h"
#include "wconfig_panel.hh"

class WConfig;
class SolidButton;

class ColorPanel : public WConfigPanel
{
public:
  ColorPanel( AWindow &basewin, WConfig &baseconfig );
  ~ColorPanel();
  int create();
  int saveValues();

  /* gui elements callback */
  void run( Widget *, AGMessage &msg );

  /* we are interested in updated colors */
  panel_action_t setColors( List *colors );
protected:
  WConfig *tempconfig;
  SolidButton *sbsb;
  Button *sbvb;
  Button *sbhb;
  SolidButton *slvbsb;
  Button *slvbvb;
  Button *slvbhb;
  SolidButton *ulvbsb;
  Button *ulvbvb;
  Button *ulvbhb;
  FieldListView *lv;
  Button *b[10][2];
  SolidButton *cbsb;
  Button *cbvb;
  Button *cbhb;
  SolidButton *rsb;
  Button *rvb;
  Button *rhb;
  Button *_tv_fg_b, *_tv_bg_b;
  Button *_tv_hfg_b, *_tv_hbg_b;
  Button *_tv_sel_fg_b, *_tv_sel_bg_b;
  SolidButton *_tv_cols_sb, *_tv_high_sb, *_tv_sel_sb;

  void setLVColors( int row, int fg, int bg );
};
 
#endif
