/*
 *  XSMC-CALC: Smith Chart Calculator program for X
 * 
 *
 *      by Lapo Pieri (IK5NAX)  2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send bugs reports, comments, critique, etc, to ik5nax@amsat.org
 */

/*---------------------------------------------------------------------------
                         Definitions & Constants
  ---------------------------------------------------------------------------*/
#define NEL 8               /* Max number of network elements */
#define QZ 0.05             /* Quasi-Zero: to draw arc as lines */
#define __VERSION "1.0.0"   /* Current version */

/*---------------------------------------------------------------------------
                             Data Strucutures
  ---------------------------------------------------------------------------*/
typedef struct maindata{
  /* General data */
  float z0;        /* Characteristic impedance [ohm] */
  float f0;        /* Main frequency [Hz] */

  /* Cursor point */
  float rerhoCU;  /* Real part of reflection coefficient at cursor */
  float imrhoCU;  /* Imaginary part of reflection coefficient at cursor */

  /* Start Point */
  char SPtype;    /* Type of start point supplyed                            */

  float rezSP;    /* Real part of start point impedance [ohm]                */
  float imzSP;    /* Imaginary part of start point impedance [ohm]           */
  float reySP;    /* Real part of start point admittance [S]                 */
  float imySP;    /* Imaginary part of start point admittance [S]            */
  float rerhoSP;  /* Real part of start point reflection coefficient []      */
  float imrhoSP;  /* Immaginary part of start point reflection coefficient []*/

  /* Network data */
  int ne;              /* Number of element present in network (<=NEL) */
  int neidx;           /* Currently selected element */
  char ELtype[NEL+1];    /* Network element type: R, L, C, T */
                       /* R=resistor, C=capacitor, L=inductor,
			  T=transmision line */
  float ELval0[NEL+1];   /* Value 0 for network element (R, L, C, lenght of T)
			  [ohm], [H], [F], [m] */
  float ELval1[NEL+1];   /* Value 0 for network element (z0 of T) [ohm] */
  float ELval2[NEL+1];   /* Value 0 for network element (atten of T) [dB/m]*/
  char ELplace[NEL+1];   /* Placement of component: s=series, p=parallel, ...
			  to be enlarged with transmission line */

  /* Impedance point */
  float rerhoIP[NEL+1];
  float imrhoIP[NEL+1];

}SMCDATA;


/*---------------------------------------------------------------------------
                             Global variables
  ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
                             Function Prototypes
  ---------------------------------------------------------------------------*/
void createcolors(void), drawchart(void), drawdata(void);
void drawRk(Display*, Drawable, GC, float), 
  drawXk(Display*, Drawable, GC, float), 
  drawGk(Display*, Drawable, GC, float), 
  drawBk(Display*, Drawable, GC, float),
  drawRHOk(Display*, Drawable, GC, float),
  drawQk(Display*, Drawable, GC, float),
  drawSP(Display*, Drawable, GC, float, float);
void drawR(Display*, Drawable, GC, float, float, float),
  drawX(Display*, Drawable, GC, float, float, float), 
  drawG(Display*, Drawable, GC, float, float, float), 
  drawB(Display*, Drawable, GC, float, float, float),
  drawRHO(Display*, Drawable, GC, float, float, float),
  drawLINE(Display*, Drawable, GC, float, float, float, float);
void z2rho(float, float, float*, float*), y2rho(float, float, float*, float*),
  rho2z(float, float, float*, float*),  rho2y(float, float, float*, float*),
  rhoz1z2(float *, float *, float, float);
void dialogwin(char *, char *, char *, char *);
void rect2polat(float *, float *), polar2rect(float *, float *);
void recalc(void), float2prefs(float , char *, int);
void removene(void);

float thetaonR(float, float, float), thetaonX(float, float, float),
  thetaonG(float, float, float), thetaonB(float, float, float);

int entrystringdecode(char *, float *, float *), 
  componentvaluestringdecode(char *,float *, float *, float *, char *);
float psdec(char *);

void writespice(char *), writerfcs(char *);

void optimize(void);
