/* gencvtables.c
 * Generates precalculated tables for Ziproxy routines.
 * This is a standalone code and not included in main Ziproxy executable.
 *
 * Ziproxy - the HTTP acceleration proxy
 * This code is under the following conditions:
 *
 * ---------------------------------------------------------------------
 * Copyright (c)2005-2014 Daniel Mealha Cabrita
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 * ---------------------------------------------------------------------
 */


#include <stdio.h>

/* convert a lower (bitwise) resolution number to a higher one */
/* inres = inval bit resolution ( < outres)
 * outres = output bit resolution
 * inval = the value to be converted */
int convert_to_higher_bitlen (int inres, int outres, int inval)
{
	int bitc;
	int outval = 0;
	int shifted_inval;

	shifted_inval = inval << (outres - inres);

	for (bitc = 0; bitc < outres; bitc += inres) {
		outval |= shifted_inval >> bitc;
	}
	return (outval);
}


void gentable_any2eight (void)
{
	int bitwidth;
	int value;
	int this_entry;
	int total_subtables = 9;

	printf ("const unsigned char table_bitres_any2eight [9][256] = { \\\n");
	for (bitwidth = 0; bitwidth < total_subtables; bitwidth++) {
		// printf ("BITWIDTH: %d\n", bitwidth);
		printf ("\t{ ");
		for (value = 0; value < 256; value++) {
			if (bitwidth == 0) {
				this_entry = 0;
			} else if (bitwidth == 8) {
				this_entry = value;
			} else {
				// crops value within bitwidth mask for aesthetic purposes (the value won't be used anyway)
				this_entry = convert_to_higher_bitlen (bitwidth, 8, value & ((1 << bitwidth) - 1));
			}
			printf ("0x%02x", this_entry);
			if (value != 255) {
				if ((value & 0x07) == 0x07)
					printf (", \\\n\t");
				else
					printf (", ");
			}

		}
		if (bitwidth < (total_subtables - 1))
			printf (" }, \\\n");
		else
			printf (" } \\\n");
	}
	printf ("\t};\n\n");
}

main ()
{
	printf ("/* cvtables.h\n"
		" * Conversion tables\n"
		" *\n"
		" * *** Do not edit this file directly, it was generated by gencvtables.c\n"
		" * *** gencvtables is not invoked neither compiled by make,\n"
		" * *** thus it should be compiled and executed manually.\n"
		" *\n"
		" * Ziproxy - the HTTP acceleration proxy\n"
		" * This code is under the following conditions:\n"
		" *\n"
		" * ---------------------------------------------------------------------\n"
		" * Copyright (c)2005-2014 Daniel Mealha Cabrita\n"
		" *\n"
		" * This program is free software; you can redistribute it and/or modify\n"
		" * it under the terms of the GNU General Public License as published by\n"
		" * the Free Software Foundation; either version 2 of the License, or\n"
		" * (at your option) any later version.\n"
		" *\n"
		" * This program is distributed in the hope that it will be useful,\n"
		" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		" * GNU General Public License for more details.\n"
		" *\n"
		" * You should have received a copy of the GNU General Public License\n"
		" * along with this program; if not, write to the Free Software\n"
		" * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA\n"
		" * ---------------------------------------------------------------------\n"
		" */\n"
		"\n\n");
	printf ("//To stop multiple inclusions.\n"
		"#ifndef CVTABLES_H\n"
		"#define CVTABLES_H\n"
		"\n"
		"#define UPSAMPLE_TO_U8BIT(value,bitlen) table_bitres_any2eight [bitlen][value]\n"
		"\n");

	gentable_any2eight ();
	
	printf ("\n"
		"#endif\n"
		"\n");
}
